/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMappingListCopier;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.GroupIdentifierListCopier;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.SpotFleetMonitoring;
import software.amazon.awssdk.services.ec2.model.SpotFleetTagSpecification;
import software.amazon.awssdk.services.ec2.model.SpotFleetTagSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.SpotPlacement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SpotFleetLaunchSpecification
implements ToCopyableBuilder<Builder, SpotFleetLaunchSpecification> {
    private final List<GroupIdentifier> securityGroups;
    private final String addressingType;
    private final List<BlockDeviceMapping> blockDeviceMappings;
    private final Boolean ebsOptimized;
    private final IamInstanceProfileSpecification iamInstanceProfile;
    private final String imageId;
    private final String instanceType;
    private final String kernelId;
    private final String keyName;
    private final SpotFleetMonitoring monitoring;
    private final List<InstanceNetworkInterfaceSpecification> networkInterfaces;
    private final SpotPlacement placement;
    private final String ramdiskId;
    private final String spotPrice;
    private final String subnetId;
    private final String userData;
    private final Double weightedCapacity;
    private final List<SpotFleetTagSpecification> tagSpecifications;

    private SpotFleetLaunchSpecification(BuilderImpl builder) {
        this.securityGroups = builder.securityGroups;
        this.addressingType = builder.addressingType;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.ebsOptimized = builder.ebsOptimized;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.imageId = builder.imageId;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.keyName = builder.keyName;
        this.monitoring = builder.monitoring;
        this.networkInterfaces = builder.networkInterfaces;
        this.placement = builder.placement;
        this.ramdiskId = builder.ramdiskId;
        this.spotPrice = builder.spotPrice;
        this.subnetId = builder.subnetId;
        this.userData = builder.userData;
        this.weightedCapacity = builder.weightedCapacity;
        this.tagSpecifications = builder.tagSpecifications;
    }

    public List<GroupIdentifier> securityGroups() {
        return this.securityGroups;
    }

    public String addressingType() {
        return this.addressingType;
    }

    public List<BlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public IamInstanceProfileSpecification iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public String imageId() {
        return this.imageId;
    }

    public InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeAsString() {
        return this.instanceType;
    }

    public String kernelId() {
        return this.kernelId;
    }

    public String keyName() {
        return this.keyName;
    }

    public SpotFleetMonitoring monitoring() {
        return this.monitoring;
    }

    public List<InstanceNetworkInterfaceSpecification> networkInterfaces() {
        return this.networkInterfaces;
    }

    public SpotPlacement placement() {
        return this.placement;
    }

    public String ramdiskId() {
        return this.ramdiskId;
    }

    public String spotPrice() {
        return this.spotPrice;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String userData() {
        return this.userData;
    }

    public Double weightedCapacity() {
        return this.weightedCapacity;
    }

    public List<SpotFleetTagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressingType());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoring());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.placement());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userData());
        hashCode = 31 * hashCode + Objects.hashCode(this.weightedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagSpecifications());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotFleetLaunchSpecification)) {
            return false;
        }
        SpotFleetLaunchSpecification other = (SpotFleetLaunchSpecification)obj;
        return Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.addressingType(), other.addressingType()) && Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized()) && Objects.equals(this.iamInstanceProfile(), other.iamInstanceProfile()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.kernelId(), other.kernelId()) && Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.monitoring(), other.monitoring()) && Objects.equals(this.networkInterfaces(), other.networkInterfaces()) && Objects.equals(this.placement(), other.placement()) && Objects.equals(this.ramdiskId(), other.ramdiskId()) && Objects.equals(this.spotPrice(), other.spotPrice()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.userData(), other.userData()) && Objects.equals(this.weightedCapacity(), other.weightedCapacity()) && Objects.equals(this.tagSpecifications(), other.tagSpecifications());
    }

    public String toString() {
        return ToString.builder((String)"SpotFleetLaunchSpecification").add("SecurityGroups", this.securityGroups()).add("AddressingType", (Object)this.addressingType()).add("BlockDeviceMappings", this.blockDeviceMappings()).add("EbsOptimized", (Object)this.ebsOptimized()).add("IamInstanceProfile", (Object)this.iamInstanceProfile()).add("ImageId", (Object)this.imageId()).add("InstanceType", (Object)this.instanceTypeAsString()).add("KernelId", (Object)this.kernelId()).add("KeyName", (Object)this.keyName()).add("Monitoring", (Object)this.monitoring()).add("NetworkInterfaces", this.networkInterfaces()).add("Placement", (Object)this.placement()).add("RamdiskId", (Object)this.ramdiskId()).add("SpotPrice", (Object)this.spotPrice()).add("SubnetId", (Object)this.subnetId()).add("UserData", (Object)this.userData()).add("WeightedCapacity", (Object)this.weightedCapacity()).add("TagSpecifications", this.tagSpecifications()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityGroups": {
                return Optional.of(clazz.cast(this.securityGroups()));
            }
            case "AddressingType": {
                return Optional.of(clazz.cast(this.addressingType()));
            }
            case "BlockDeviceMappings": {
                return Optional.of(clazz.cast(this.blockDeviceMappings()));
            }
            case "EbsOptimized": {
                return Optional.of(clazz.cast(this.ebsOptimized()));
            }
            case "IamInstanceProfile": {
                return Optional.of(clazz.cast(this.iamInstanceProfile()));
            }
            case "ImageId": {
                return Optional.of(clazz.cast(this.imageId()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceTypeAsString()));
            }
            case "KernelId": {
                return Optional.of(clazz.cast(this.kernelId()));
            }
            case "KeyName": {
                return Optional.of(clazz.cast(this.keyName()));
            }
            case "Monitoring": {
                return Optional.of(clazz.cast(this.monitoring()));
            }
            case "NetworkInterfaces": {
                return Optional.of(clazz.cast(this.networkInterfaces()));
            }
            case "Placement": {
                return Optional.of(clazz.cast(this.placement()));
            }
            case "RamdiskId": {
                return Optional.of(clazz.cast(this.ramdiskId()));
            }
            case "SpotPrice": {
                return Optional.of(clazz.cast(this.spotPrice()));
            }
            case "SubnetId": {
                return Optional.of(clazz.cast(this.subnetId()));
            }
            case "UserData": {
                return Optional.of(clazz.cast(this.userData()));
            }
            case "WeightedCapacity": {
                return Optional.of(clazz.cast(this.weightedCapacity()));
            }
            case "TagSpecifications": {
                return Optional.of(clazz.cast(this.tagSpecifications()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<GroupIdentifier> securityGroups;
        private String addressingType;
        private List<BlockDeviceMapping> blockDeviceMappings;
        private Boolean ebsOptimized;
        private IamInstanceProfileSpecification iamInstanceProfile;
        private String imageId;
        private String instanceType;
        private String kernelId;
        private String keyName;
        private SpotFleetMonitoring monitoring;
        private List<InstanceNetworkInterfaceSpecification> networkInterfaces;
        private SpotPlacement placement;
        private String ramdiskId;
        private String spotPrice;
        private String subnetId;
        private String userData;
        private Double weightedCapacity;
        private List<SpotFleetTagSpecification> tagSpecifications;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotFleetLaunchSpecification model) {
            this.securityGroups(model.securityGroups);
            this.addressingType(model.addressingType);
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.ebsOptimized(model.ebsOptimized);
            this.iamInstanceProfile(model.iamInstanceProfile);
            this.imageId(model.imageId);
            this.instanceType(model.instanceType);
            this.kernelId(model.kernelId);
            this.keyName(model.keyName);
            this.monitoring(model.monitoring);
            this.networkInterfaces(model.networkInterfaces);
            this.placement(model.placement);
            this.ramdiskId(model.ramdiskId);
            this.spotPrice(model.spotPrice);
            this.subnetId(model.subnetId);
            this.userData(model.userData);
            this.weightedCapacity(model.weightedCapacity);
            this.tagSpecifications(model.tagSpecifications);
        }

        public final Collection<GroupIdentifier.Builder> getSecurityGroups() {
            return this.securityGroups != null ? (Collection)this.securityGroups.stream().map(GroupIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder securityGroups(Collection<GroupIdentifier> securityGroups) {
            this.securityGroups = GroupIdentifierListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(GroupIdentifier ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(Consumer<GroupIdentifier.Builder> ... securityGroups) {
            this.securityGroups(Stream.of(securityGroups).map(c -> (GroupIdentifier)((GroupIdentifier.Builder)GroupIdentifier.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecurityGroups(Collection<GroupIdentifier.BuilderImpl> securityGroups) {
            this.securityGroups = GroupIdentifierListCopier.copyFromBuilder(securityGroups);
        }

        public final String getAddressingType() {
            return this.addressingType;
        }

        @Override
        public final Builder addressingType(String addressingType) {
            this.addressingType = addressingType;
            return this;
        }

        public final void setAddressingType(String addressingType) {
            this.addressingType = addressingType;
        }

        public final Collection<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return this.blockDeviceMappings != null ? (Collection)this.blockDeviceMappings.stream().map(BlockDeviceMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder> ... blockDeviceMappings) {
            this.blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> (BlockDeviceMapping)((BlockDeviceMapping.Builder)BlockDeviceMapping.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final IamInstanceProfileSpecification.Builder getIamInstanceProfile() {
            return this.iamInstanceProfile != null ? this.iamInstanceProfile.toBuilder() : null;
        }

        @Override
        public final Builder iamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(IamInstanceProfileSpecification.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final SpotFleetMonitoring.Builder getMonitoring() {
            return this.monitoring != null ? this.monitoring.toBuilder() : null;
        }

        @Override
        public final Builder monitoring(SpotFleetMonitoring monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final void setMonitoring(SpotFleetMonitoring.BuilderImpl monitoring) {
            this.monitoring = monitoring != null ? monitoring.build() : null;
        }

        public final Collection<InstanceNetworkInterfaceSpecification.Builder> getNetworkInterfaces() {
            return this.networkInterfaces != null ? (Collection)this.networkInterfaces.stream().map(InstanceNetworkInterfaceSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceSpecificationListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(InstanceNetworkInterfaceSpecification ... networkInterfaces) {
            this.networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<InstanceNetworkInterfaceSpecification.Builder> ... networkInterfaces) {
            this.networkInterfaces(Stream.of(networkInterfaces).map(c -> (InstanceNetworkInterfaceSpecification)((InstanceNetworkInterfaceSpecification.Builder)InstanceNetworkInterfaceSpecification.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkInterfaces(Collection<InstanceNetworkInterfaceSpecification.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceSpecificationListCopier.copyFromBuilder(networkInterfaces);
        }

        public final SpotPlacement.Builder getPlacement() {
            return this.placement != null ? this.placement.toBuilder() : null;
        }

        @Override
        public final Builder placement(SpotPlacement placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(SpotPlacement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        public final String getRamdiskId() {
            return this.ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final String getSpotPrice() {
            return this.spotPrice;
        }

        @Override
        public final Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public final void setSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getUserData() {
            return this.userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final Double getWeightedCapacity() {
            return this.weightedCapacity;
        }

        @Override
        public final Builder weightedCapacity(Double weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
            return this;
        }

        public final void setWeightedCapacity(Double weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
        }

        public final Collection<SpotFleetTagSpecification.Builder> getTagSpecifications() {
            return this.tagSpecifications != null ? (Collection)this.tagSpecifications.stream().map(SpotFleetTagSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSpecifications(Collection<SpotFleetTagSpecification> tagSpecifications) {
            this.tagSpecifications = SpotFleetTagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(SpotFleetTagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<SpotFleetTagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (SpotFleetTagSpecification)((SpotFleetTagSpecification.Builder)SpotFleetTagSpecification.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<SpotFleetTagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = SpotFleetTagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        public SpotFleetLaunchSpecification build() {
            return new SpotFleetLaunchSpecification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SpotFleetLaunchSpecification> {
        public Builder securityGroups(Collection<GroupIdentifier> var1);

        public Builder securityGroups(GroupIdentifier ... var1);

        public Builder securityGroups(Consumer<GroupIdentifier.Builder> ... var1);

        public Builder addressingType(String var1);

        public Builder blockDeviceMappings(Collection<BlockDeviceMapping> var1);

        public Builder blockDeviceMappings(BlockDeviceMapping ... var1);

        public Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder> ... var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder iamInstanceProfile(IamInstanceProfileSpecification var1);

        default public Builder iamInstanceProfile(Consumer<IamInstanceProfileSpecification.Builder> iamInstanceProfile) {
            return this.iamInstanceProfile((IamInstanceProfileSpecification)((IamInstanceProfileSpecification.Builder)IamInstanceProfileSpecification.builder().apply(iamInstanceProfile)).build());
        }

        public Builder imageId(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder kernelId(String var1);

        public Builder keyName(String var1);

        public Builder monitoring(SpotFleetMonitoring var1);

        default public Builder monitoring(Consumer<SpotFleetMonitoring.Builder> monitoring) {
            return this.monitoring((SpotFleetMonitoring)((SpotFleetMonitoring.Builder)SpotFleetMonitoring.builder().apply(monitoring)).build());
        }

        public Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> var1);

        public Builder networkInterfaces(InstanceNetworkInterfaceSpecification ... var1);

        public Builder networkInterfaces(Consumer<InstanceNetworkInterfaceSpecification.Builder> ... var1);

        public Builder placement(SpotPlacement var1);

        default public Builder placement(Consumer<SpotPlacement.Builder> placement) {
            return this.placement((SpotPlacement)((SpotPlacement.Builder)SpotPlacement.builder().apply(placement)).build());
        }

        public Builder ramdiskId(String var1);

        public Builder spotPrice(String var1);

        public Builder subnetId(String var1);

        public Builder userData(String var1);

        public Builder weightedCapacity(Double var1);

        public Builder tagSpecifications(Collection<SpotFleetTagSpecification> var1);

        public Builder tagSpecifications(SpotFleetTagSpecification ... var1);

        public Builder tagSpecifications(Consumer<SpotFleetTagSpecification.Builder> ... var1);
    }
}

