/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMappingRequestListCopier;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.ElasticGpuSpecification;
import software.amazon.awssdk.services.ec2.model.ElasticGpuSpecificationsCopier;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6Address;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6AddressListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.Placement;
import software.amazon.awssdk.services.ec2.model.SecurityGroupIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.SecurityGroupStringListCopier;
import software.amazon.awssdk.services.ec2.model.ShutdownBehavior;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RunInstancesRequest
extends EC2Request
implements ToCopyableBuilder<Builder, RunInstancesRequest> {
    private final List<BlockDeviceMapping> blockDeviceMappings;
    private final String imageId;
    private final String instanceType;
    private final Integer ipv6AddressCount;
    private final List<InstanceIpv6Address> ipv6Addresses;
    private final String kernelId;
    private final String keyName;
    private final Integer maxCount;
    private final Integer minCount;
    private final Boolean monitoring;
    private final Placement placement;
    private final String ramdiskId;
    private final List<String> securityGroupIds;
    private final List<String> securityGroups;
    private final String subnetId;
    private final String userData;
    private final String additionalInfo;
    private final String clientToken;
    private final Boolean disableApiTermination;
    private final Boolean ebsOptimized;
    private final IamInstanceProfileSpecification iamInstanceProfile;
    private final String instanceInitiatedShutdownBehavior;
    private final List<InstanceNetworkInterfaceSpecification> networkInterfaces;
    private final String privateIpAddress;
    private final List<ElasticGpuSpecification> elasticGpuSpecification;
    private final List<TagSpecification> tagSpecifications;

    private RunInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.imageId = builder.imageId;
        this.instanceType = builder.instanceType;
        this.ipv6AddressCount = builder.ipv6AddressCount;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.kernelId = builder.kernelId;
        this.keyName = builder.keyName;
        this.maxCount = builder.maxCount;
        this.minCount = builder.minCount;
        this.monitoring = builder.monitoring;
        this.placement = builder.placement;
        this.ramdiskId = builder.ramdiskId;
        this.securityGroupIds = builder.securityGroupIds;
        this.securityGroups = builder.securityGroups;
        this.subnetId = builder.subnetId;
        this.userData = builder.userData;
        this.additionalInfo = builder.additionalInfo;
        this.clientToken = builder.clientToken;
        this.disableApiTermination = builder.disableApiTermination;
        this.ebsOptimized = builder.ebsOptimized;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
        this.networkInterfaces = builder.networkInterfaces;
        this.privateIpAddress = builder.privateIpAddress;
        this.elasticGpuSpecification = builder.elasticGpuSpecification;
        this.tagSpecifications = builder.tagSpecifications;
    }

    public List<BlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public String imageId() {
        return this.imageId;
    }

    public InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeAsString() {
        return this.instanceType;
    }

    public Integer ipv6AddressCount() {
        return this.ipv6AddressCount;
    }

    public List<InstanceIpv6Address> ipv6Addresses() {
        return this.ipv6Addresses;
    }

    public String kernelId() {
        return this.kernelId;
    }

    public String keyName() {
        return this.keyName;
    }

    public Integer maxCount() {
        return this.maxCount;
    }

    public Integer minCount() {
        return this.minCount;
    }

    public Boolean monitoring() {
        return this.monitoring;
    }

    public Placement placement() {
        return this.placement;
    }

    public String ramdiskId() {
        return this.ramdiskId;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String userData() {
        return this.userData;
    }

    public String additionalInfo() {
        return this.additionalInfo;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public Boolean disableApiTermination() {
        return this.disableApiTermination;
    }

    public Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public IamInstanceProfileSpecification iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public ShutdownBehavior instanceInitiatedShutdownBehavior() {
        return ShutdownBehavior.fromValue(this.instanceInitiatedShutdownBehavior);
    }

    public String instanceInitiatedShutdownBehaviorAsString() {
        return this.instanceInitiatedShutdownBehavior;
    }

    public List<InstanceNetworkInterfaceSpecification> networkInterfaces() {
        return this.networkInterfaces;
    }

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public List<ElasticGpuSpecification> elasticGpuSpecification() {
        return this.elasticGpuSpecification;
    }

    public List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6AddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6Addresses());
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.minCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoring());
        hashCode = 31 * hashCode + Objects.hashCode(this.placement());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userData());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableApiTermination());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceInitiatedShutdownBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticGpuSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagSpecifications());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunInstancesRequest)) {
            return false;
        }
        RunInstancesRequest other = (RunInstancesRequest)((Object)obj);
        return Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.ipv6AddressCount(), other.ipv6AddressCount()) && Objects.equals(this.ipv6Addresses(), other.ipv6Addresses()) && Objects.equals(this.kernelId(), other.kernelId()) && Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.maxCount(), other.maxCount()) && Objects.equals(this.minCount(), other.minCount()) && Objects.equals(this.monitoring(), other.monitoring()) && Objects.equals(this.placement(), other.placement()) && Objects.equals(this.ramdiskId(), other.ramdiskId()) && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.userData(), other.userData()) && Objects.equals(this.additionalInfo(), other.additionalInfo()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.disableApiTermination(), other.disableApiTermination()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized()) && Objects.equals(this.iamInstanceProfile(), other.iamInstanceProfile()) && Objects.equals(this.instanceInitiatedShutdownBehaviorAsString(), other.instanceInitiatedShutdownBehaviorAsString()) && Objects.equals(this.networkInterfaces(), other.networkInterfaces()) && Objects.equals(this.privateIpAddress(), other.privateIpAddress()) && Objects.equals(this.elasticGpuSpecification(), other.elasticGpuSpecification()) && Objects.equals(this.tagSpecifications(), other.tagSpecifications());
    }

    public String toString() {
        return ToString.builder((String)"RunInstancesRequest").add("BlockDeviceMappings", this.blockDeviceMappings()).add("ImageId", (Object)this.imageId()).add("InstanceType", (Object)this.instanceTypeAsString()).add("Ipv6AddressCount", (Object)this.ipv6AddressCount()).add("Ipv6Addresses", this.ipv6Addresses()).add("KernelId", (Object)this.kernelId()).add("KeyName", (Object)this.keyName()).add("MaxCount", (Object)this.maxCount()).add("MinCount", (Object)this.minCount()).add("Monitoring", (Object)this.monitoring()).add("Placement", (Object)this.placement()).add("RamdiskId", (Object)this.ramdiskId()).add("SecurityGroupIds", this.securityGroupIds()).add("SecurityGroups", this.securityGroups()).add("SubnetId", (Object)this.subnetId()).add("UserData", (Object)this.userData()).add("AdditionalInfo", (Object)this.additionalInfo()).add("ClientToken", (Object)this.clientToken()).add("DisableApiTermination", (Object)this.disableApiTermination()).add("EbsOptimized", (Object)this.ebsOptimized()).add("IamInstanceProfile", (Object)this.iamInstanceProfile()).add("InstanceInitiatedShutdownBehavior", (Object)this.instanceInitiatedShutdownBehaviorAsString()).add("NetworkInterfaces", this.networkInterfaces()).add("PrivateIpAddress", (Object)this.privateIpAddress()).add("ElasticGpuSpecification", this.elasticGpuSpecification()).add("TagSpecifications", this.tagSpecifications()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlockDeviceMappings": {
                return Optional.of(clazz.cast(this.blockDeviceMappings()));
            }
            case "ImageId": {
                return Optional.of(clazz.cast(this.imageId()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceTypeAsString()));
            }
            case "Ipv6AddressCount": {
                return Optional.of(clazz.cast(this.ipv6AddressCount()));
            }
            case "Ipv6Addresses": {
                return Optional.of(clazz.cast(this.ipv6Addresses()));
            }
            case "KernelId": {
                return Optional.of(clazz.cast(this.kernelId()));
            }
            case "KeyName": {
                return Optional.of(clazz.cast(this.keyName()));
            }
            case "MaxCount": {
                return Optional.of(clazz.cast(this.maxCount()));
            }
            case "MinCount": {
                return Optional.of(clazz.cast(this.minCount()));
            }
            case "Monitoring": {
                return Optional.of(clazz.cast(this.monitoring()));
            }
            case "Placement": {
                return Optional.of(clazz.cast(this.placement()));
            }
            case "RamdiskId": {
                return Optional.of(clazz.cast(this.ramdiskId()));
            }
            case "SecurityGroupIds": {
                return Optional.of(clazz.cast(this.securityGroupIds()));
            }
            case "SecurityGroups": {
                return Optional.of(clazz.cast(this.securityGroups()));
            }
            case "SubnetId": {
                return Optional.of(clazz.cast(this.subnetId()));
            }
            case "UserData": {
                return Optional.of(clazz.cast(this.userData()));
            }
            case "AdditionalInfo": {
                return Optional.of(clazz.cast(this.additionalInfo()));
            }
            case "ClientToken": {
                return Optional.of(clazz.cast(this.clientToken()));
            }
            case "DisableApiTermination": {
                return Optional.of(clazz.cast(this.disableApiTermination()));
            }
            case "EbsOptimized": {
                return Optional.of(clazz.cast(this.ebsOptimized()));
            }
            case "IamInstanceProfile": {
                return Optional.of(clazz.cast(this.iamInstanceProfile()));
            }
            case "InstanceInitiatedShutdownBehavior": {
                return Optional.of(clazz.cast(this.instanceInitiatedShutdownBehaviorAsString()));
            }
            case "NetworkInterfaces": {
                return Optional.of(clazz.cast(this.networkInterfaces()));
            }
            case "PrivateIpAddress": {
                return Optional.of(clazz.cast(this.privateIpAddress()));
            }
            case "ElasticGpuSpecification": {
                return Optional.of(clazz.cast(this.elasticGpuSpecification()));
            }
            case "TagSpecifications": {
                return Optional.of(clazz.cast(this.tagSpecifications()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private List<BlockDeviceMapping> blockDeviceMappings;
        private String imageId;
        private String instanceType;
        private Integer ipv6AddressCount;
        private List<InstanceIpv6Address> ipv6Addresses;
        private String kernelId;
        private String keyName;
        private Integer maxCount;
        private Integer minCount;
        private Boolean monitoring;
        private Placement placement;
        private String ramdiskId;
        private List<String> securityGroupIds;
        private List<String> securityGroups;
        private String subnetId;
        private String userData;
        private String additionalInfo;
        private String clientToken;
        private Boolean disableApiTermination;
        private Boolean ebsOptimized;
        private IamInstanceProfileSpecification iamInstanceProfile;
        private String instanceInitiatedShutdownBehavior;
        private List<InstanceNetworkInterfaceSpecification> networkInterfaces;
        private String privateIpAddress;
        private List<ElasticGpuSpecification> elasticGpuSpecification;
        private List<TagSpecification> tagSpecifications;

        private BuilderImpl() {
        }

        private BuilderImpl(RunInstancesRequest model) {
            super(model);
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.imageId(model.imageId);
            this.instanceType(model.instanceType);
            this.ipv6AddressCount(model.ipv6AddressCount);
            this.ipv6Addresses(model.ipv6Addresses);
            this.kernelId(model.kernelId);
            this.keyName(model.keyName);
            this.maxCount(model.maxCount);
            this.minCount(model.minCount);
            this.monitoring(model.monitoring);
            this.placement(model.placement);
            this.ramdiskId(model.ramdiskId);
            this.securityGroupIds(model.securityGroupIds);
            this.securityGroups(model.securityGroups);
            this.subnetId(model.subnetId);
            this.userData(model.userData);
            this.additionalInfo(model.additionalInfo);
            this.clientToken(model.clientToken);
            this.disableApiTermination(model.disableApiTermination);
            this.ebsOptimized(model.ebsOptimized);
            this.iamInstanceProfile(model.iamInstanceProfile);
            this.instanceInitiatedShutdownBehavior(model.instanceInitiatedShutdownBehavior);
            this.networkInterfaces(model.networkInterfaces);
            this.privateIpAddress(model.privateIpAddress);
            this.elasticGpuSpecification(model.elasticGpuSpecification);
            this.tagSpecifications(model.tagSpecifications);
        }

        public final Collection<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return this.blockDeviceMappings != null ? (Collection)this.blockDeviceMappings.stream().map(BlockDeviceMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingRequestListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder> ... blockDeviceMappings) {
            this.blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> (BlockDeviceMapping)((BlockDeviceMapping.Builder)BlockDeviceMapping.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingRequestListCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getIpv6AddressCount() {
            return this.ipv6AddressCount;
        }

        @Override
        public final Builder ipv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        public final void setIpv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
        }

        public final Collection<InstanceIpv6Address.Builder> getIpv6Addresses() {
            return this.ipv6Addresses != null ? (Collection)this.ipv6Addresses.stream().map(InstanceIpv6Address::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(InstanceIpv6Address ... ipv6Addresses) {
            this.ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(Consumer<InstanceIpv6Address.Builder> ... ipv6Addresses) {
            this.ipv6Addresses(Stream.of(ipv6Addresses).map(c -> (InstanceIpv6Address)((InstanceIpv6Address.Builder)InstanceIpv6Address.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpv6Addresses(Collection<InstanceIpv6Address.BuilderImpl> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copyFromBuilder(ipv6Addresses);
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final Integer getMaxCount() {
            return this.maxCount;
        }

        @Override
        public final Builder maxCount(Integer maxCount) {
            this.maxCount = maxCount;
            return this;
        }

        public final void setMaxCount(Integer maxCount) {
            this.maxCount = maxCount;
        }

        public final Integer getMinCount() {
            return this.minCount;
        }

        @Override
        public final Builder minCount(Integer minCount) {
            this.minCount = minCount;
            return this;
        }

        public final void setMinCount(Integer minCount) {
            this.minCount = minCount;
        }

        public final Boolean getMonitoring() {
            return this.monitoring;
        }

        @Override
        public final Builder monitoring(Boolean monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final void setMonitoring(Boolean monitoring) {
            this.monitoring = monitoring;
        }

        public final Placement.Builder getPlacement() {
            return this.placement != null ? this.placement.toBuilder() : null;
        }

        @Override
        public final Builder placement(Placement placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(Placement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        public final String getRamdiskId() {
            return this.ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdStringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdStringListCopier.copy(securityGroupIds);
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupStringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupStringListCopier.copy(securityGroups);
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getUserData() {
            return this.userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final String getAdditionalInfo() {
            return this.additionalInfo;
        }

        @Override
        public final Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public final void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Boolean getDisableApiTermination() {
            return this.disableApiTermination;
        }

        @Override
        public final Builder disableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        public final void setDisableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final IamInstanceProfileSpecification.Builder getIamInstanceProfile() {
            return this.iamInstanceProfile != null ? this.iamInstanceProfile.toBuilder() : null;
        }

        @Override
        public final Builder iamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(IamInstanceProfileSpecification.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        public final String getInstanceInitiatedShutdownBehavior() {
            return this.instanceInitiatedShutdownBehavior;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior.toString());
            return this;
        }

        public final void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
        }

        public final Collection<InstanceNetworkInterfaceSpecification.Builder> getNetworkInterfaces() {
            return this.networkInterfaces != null ? (Collection)this.networkInterfaces.stream().map(InstanceNetworkInterfaceSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceSpecificationListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(InstanceNetworkInterfaceSpecification ... networkInterfaces) {
            this.networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<InstanceNetworkInterfaceSpecification.Builder> ... networkInterfaces) {
            this.networkInterfaces(Stream.of(networkInterfaces).map(c -> (InstanceNetworkInterfaceSpecification)((InstanceNetworkInterfaceSpecification.Builder)InstanceNetworkInterfaceSpecification.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkInterfaces(Collection<InstanceNetworkInterfaceSpecification.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceSpecificationListCopier.copyFromBuilder(networkInterfaces);
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final Collection<ElasticGpuSpecification.Builder> getElasticGpuSpecification() {
            return this.elasticGpuSpecification != null ? (Collection)this.elasticGpuSpecification.stream().map(ElasticGpuSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder elasticGpuSpecification(Collection<ElasticGpuSpecification> elasticGpuSpecification) {
            this.elasticGpuSpecification = ElasticGpuSpecificationsCopier.copy(elasticGpuSpecification);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuSpecification(ElasticGpuSpecification ... elasticGpuSpecification) {
            this.elasticGpuSpecification(Arrays.asList(elasticGpuSpecification));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuSpecification(Consumer<ElasticGpuSpecification.Builder> ... elasticGpuSpecification) {
            this.elasticGpuSpecification(Stream.of(elasticGpuSpecification).map(c -> (ElasticGpuSpecification)((ElasticGpuSpecification.Builder)ElasticGpuSpecification.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setElasticGpuSpecification(Collection<ElasticGpuSpecification.BuilderImpl> elasticGpuSpecification) {
            this.elasticGpuSpecification = ElasticGpuSpecificationsCopier.copyFromBuilder(elasticGpuSpecification);
        }

        public final Collection<TagSpecification.Builder> getTagSpecifications() {
            return this.tagSpecifications != null ? (Collection)this.tagSpecifications.stream().map(TagSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RunInstancesRequest build() {
            return new RunInstancesRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, RunInstancesRequest> {
        public Builder blockDeviceMappings(Collection<BlockDeviceMapping> var1);

        public Builder blockDeviceMappings(BlockDeviceMapping ... var1);

        public Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder> ... var1);

        public Builder imageId(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder ipv6AddressCount(Integer var1);

        public Builder ipv6Addresses(Collection<InstanceIpv6Address> var1);

        public Builder ipv6Addresses(InstanceIpv6Address ... var1);

        public Builder ipv6Addresses(Consumer<InstanceIpv6Address.Builder> ... var1);

        public Builder kernelId(String var1);

        public Builder keyName(String var1);

        public Builder maxCount(Integer var1);

        public Builder minCount(Integer var1);

        public Builder monitoring(Boolean var1);

        public Builder placement(Placement var1);

        default public Builder placement(Consumer<Placement.Builder> placement) {
            return this.placement((Placement)((Placement.Builder)Placement.builder().apply(placement)).build());
        }

        public Builder ramdiskId(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder subnetId(String var1);

        public Builder userData(String var1);

        public Builder additionalInfo(String var1);

        public Builder clientToken(String var1);

        public Builder disableApiTermination(Boolean var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder iamInstanceProfile(IamInstanceProfileSpecification var1);

        default public Builder iamInstanceProfile(Consumer<IamInstanceProfileSpecification.Builder> iamInstanceProfile) {
            return this.iamInstanceProfile((IamInstanceProfileSpecification)((IamInstanceProfileSpecification.Builder)IamInstanceProfileSpecification.builder().apply(iamInstanceProfile)).build());
        }

        public Builder instanceInitiatedShutdownBehavior(String var1);

        public Builder instanceInitiatedShutdownBehavior(ShutdownBehavior var1);

        public Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> var1);

        public Builder networkInterfaces(InstanceNetworkInterfaceSpecification ... var1);

        public Builder networkInterfaces(Consumer<InstanceNetworkInterfaceSpecification.Builder> ... var1);

        public Builder privateIpAddress(String var1);

        public Builder elasticGpuSpecification(Collection<ElasticGpuSpecification> var1);

        public Builder elasticGpuSpecification(ElasticGpuSpecification ... var1);

        public Builder elasticGpuSpecification(Consumer<ElasticGpuSpecification.Builder> ... var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

