/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PciId
implements ToCopyableBuilder<Builder, PciId> {
    private final String deviceId;
    private final String vendorId;
    private final String subsystemId;
    private final String subsystemVendorId;

    private PciId(BuilderImpl builder) {
        this.deviceId = builder.deviceId;
        this.vendorId = builder.vendorId;
        this.subsystemId = builder.subsystemId;
        this.subsystemVendorId = builder.subsystemVendorId;
    }

    public String deviceId() {
        return this.deviceId;
    }

    public String vendorId() {
        return this.vendorId;
    }

    public String subsystemId() {
        return this.subsystemId;
    }

    public String subsystemVendorId() {
        return this.subsystemVendorId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vendorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subsystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subsystemVendorId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PciId)) {
            return false;
        }
        PciId other = (PciId)obj;
        return Objects.equals(this.deviceId(), other.deviceId()) && Objects.equals(this.vendorId(), other.vendorId()) && Objects.equals(this.subsystemId(), other.subsystemId()) && Objects.equals(this.subsystemVendorId(), other.subsystemVendorId());
    }

    public String toString() {
        return ToString.builder((String)"PciId").add("DeviceId", (Object)this.deviceId()).add("VendorId", (Object)this.vendorId()).add("SubsystemId", (Object)this.subsystemId()).add("SubsystemVendorId", (Object)this.subsystemVendorId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceId": {
                return Optional.of(clazz.cast(this.deviceId()));
            }
            case "VendorId": {
                return Optional.of(clazz.cast(this.vendorId()));
            }
            case "SubsystemId": {
                return Optional.of(clazz.cast(this.subsystemId()));
            }
            case "SubsystemVendorId": {
                return Optional.of(clazz.cast(this.subsystemVendorId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceId;
        private String vendorId;
        private String subsystemId;
        private String subsystemVendorId;

        private BuilderImpl() {
        }

        private BuilderImpl(PciId model) {
            this.deviceId(model.deviceId);
            this.vendorId(model.vendorId);
            this.subsystemId(model.subsystemId);
            this.subsystemVendorId(model.subsystemVendorId);
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        public final String getVendorId() {
            return this.vendorId;
        }

        @Override
        public final Builder vendorId(String vendorId) {
            this.vendorId = vendorId;
            return this;
        }

        public final void setVendorId(String vendorId) {
            this.vendorId = vendorId;
        }

        public final String getSubsystemId() {
            return this.subsystemId;
        }

        @Override
        public final Builder subsystemId(String subsystemId) {
            this.subsystemId = subsystemId;
            return this;
        }

        public final void setSubsystemId(String subsystemId) {
            this.subsystemId = subsystemId;
        }

        public final String getSubsystemVendorId() {
            return this.subsystemVendorId;
        }

        @Override
        public final Builder subsystemVendorId(String subsystemVendorId) {
            this.subsystemVendorId = subsystemVendorId;
            return this;
        }

        public final void setSubsystemVendorId(String subsystemVendorId) {
            this.subsystemVendorId = subsystemVendorId;
        }

        public PciId build() {
            return new PciId(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PciId> {
        public Builder deviceId(String var1);

        public Builder vendorId(String var1);

        public Builder subsystemId(String var1);

        public Builder subsystemVendorId(String var1);
    }
}

