/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMappingListCopier;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.GroupIdentifierListCopier;
import software.amazon.awssdk.services.ec2.model.GroupNameStringListCopier;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.SpotPlacement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LaunchSpecification
implements ToCopyableBuilder<Builder, LaunchSpecification> {
    private final String userData;
    private final String addressingType;
    private final List<BlockDeviceMapping> blockDeviceMappings;
    private final Boolean ebsOptimized;
    private final IamInstanceProfileSpecification iamInstanceProfile;
    private final String imageId;
    private final String instanceType;
    private final String kernelId;
    private final String keyName;
    private final List<InstanceNetworkInterfaceSpecification> networkInterfaces;
    private final SpotPlacement placement;
    private final String ramdiskId;
    private final String subnetId;
    private final List<GroupIdentifier> allSecurityGroups;
    private final Boolean monitoringEnabled;
    private final List<String> securityGroups;

    private LaunchSpecification(BuilderImpl builder) {
        this.userData = builder.userData;
        this.addressingType = builder.addressingType;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.ebsOptimized = builder.ebsOptimized;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.imageId = builder.imageId;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.keyName = builder.keyName;
        this.networkInterfaces = builder.networkInterfaces;
        this.placement = builder.placement;
        this.ramdiskId = builder.ramdiskId;
        this.subnetId = builder.subnetId;
        this.allSecurityGroups = builder.allSecurityGroups;
        this.monitoringEnabled = builder.monitoringEnabled;
        this.securityGroups = builder.securityGroups;
    }

    public String userData() {
        return this.userData;
    }

    public String addressingType() {
        return this.addressingType;
    }

    public List<BlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public IamInstanceProfileSpecification iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public String imageId() {
        return this.imageId;
    }

    public InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeAsString() {
        return this.instanceType;
    }

    public String kernelId() {
        return this.kernelId;
    }

    public String keyName() {
        return this.keyName;
    }

    public List<InstanceNetworkInterfaceSpecification> networkInterfaces() {
        return this.networkInterfaces;
    }

    public SpotPlacement placement() {
        return this.placement;
    }

    public String ramdiskId() {
        return this.ramdiskId;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public List<GroupIdentifier> allSecurityGroups() {
        return this.allSecurityGroups;
    }

    public Boolean monitoringEnabled() {
        return this.monitoringEnabled;
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userData());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressingType());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.placement());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.allSecurityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchSpecification)) {
            return false;
        }
        LaunchSpecification other = (LaunchSpecification)obj;
        return Objects.equals(this.userData(), other.userData()) && Objects.equals(this.addressingType(), other.addressingType()) && Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized()) && Objects.equals(this.iamInstanceProfile(), other.iamInstanceProfile()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.kernelId(), other.kernelId()) && Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.networkInterfaces(), other.networkInterfaces()) && Objects.equals(this.placement(), other.placement()) && Objects.equals(this.ramdiskId(), other.ramdiskId()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.allSecurityGroups(), other.allSecurityGroups()) && Objects.equals(this.monitoringEnabled(), other.monitoringEnabled()) && Objects.equals(this.securityGroups(), other.securityGroups());
    }

    public String toString() {
        return ToString.builder((String)"LaunchSpecification").add("UserData", (Object)this.userData()).add("AddressingType", (Object)this.addressingType()).add("BlockDeviceMappings", this.blockDeviceMappings()).add("EbsOptimized", (Object)this.ebsOptimized()).add("IamInstanceProfile", (Object)this.iamInstanceProfile()).add("ImageId", (Object)this.imageId()).add("InstanceType", (Object)this.instanceTypeAsString()).add("KernelId", (Object)this.kernelId()).add("KeyName", (Object)this.keyName()).add("NetworkInterfaces", this.networkInterfaces()).add("Placement", (Object)this.placement()).add("RamdiskId", (Object)this.ramdiskId()).add("SubnetId", (Object)this.subnetId()).add("AllSecurityGroups", this.allSecurityGroups()).add("MonitoringEnabled", (Object)this.monitoringEnabled()).add("SecurityGroups", this.securityGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserData": {
                return Optional.of(clazz.cast(this.userData()));
            }
            case "AddressingType": {
                return Optional.of(clazz.cast(this.addressingType()));
            }
            case "BlockDeviceMappings": {
                return Optional.of(clazz.cast(this.blockDeviceMappings()));
            }
            case "EbsOptimized": {
                return Optional.of(clazz.cast(this.ebsOptimized()));
            }
            case "IamInstanceProfile": {
                return Optional.of(clazz.cast(this.iamInstanceProfile()));
            }
            case "ImageId": {
                return Optional.of(clazz.cast(this.imageId()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceTypeAsString()));
            }
            case "KernelId": {
                return Optional.of(clazz.cast(this.kernelId()));
            }
            case "KeyName": {
                return Optional.of(clazz.cast(this.keyName()));
            }
            case "NetworkInterfaces": {
                return Optional.of(clazz.cast(this.networkInterfaces()));
            }
            case "Placement": {
                return Optional.of(clazz.cast(this.placement()));
            }
            case "RamdiskId": {
                return Optional.of(clazz.cast(this.ramdiskId()));
            }
            case "SubnetId": {
                return Optional.of(clazz.cast(this.subnetId()));
            }
            case "AllSecurityGroups": {
                return Optional.of(clazz.cast(this.allSecurityGroups()));
            }
            case "MonitoringEnabled": {
                return Optional.of(clazz.cast(this.monitoringEnabled()));
            }
            case "SecurityGroups": {
                return Optional.of(clazz.cast(this.securityGroups()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String userData;
        private String addressingType;
        private List<BlockDeviceMapping> blockDeviceMappings;
        private Boolean ebsOptimized;
        private IamInstanceProfileSpecification iamInstanceProfile;
        private String imageId;
        private String instanceType;
        private String kernelId;
        private String keyName;
        private List<InstanceNetworkInterfaceSpecification> networkInterfaces;
        private SpotPlacement placement;
        private String ramdiskId;
        private String subnetId;
        private List<GroupIdentifier> allSecurityGroups;
        private Boolean monitoringEnabled;
        private List<String> securityGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchSpecification model) {
            this.userData(model.userData);
            this.addressingType(model.addressingType);
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.ebsOptimized(model.ebsOptimized);
            this.iamInstanceProfile(model.iamInstanceProfile);
            this.imageId(model.imageId);
            this.instanceType(model.instanceType);
            this.kernelId(model.kernelId);
            this.keyName(model.keyName);
            this.networkInterfaces(model.networkInterfaces);
            this.placement(model.placement);
            this.ramdiskId(model.ramdiskId);
            this.subnetId(model.subnetId);
            this.allSecurityGroups(model.allSecurityGroups);
            this.monitoringEnabled(model.monitoringEnabled);
            this.securityGroups(model.securityGroups);
        }

        public final String getUserData() {
            return this.userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final String getAddressingType() {
            return this.addressingType;
        }

        @Override
        public final Builder addressingType(String addressingType) {
            this.addressingType = addressingType;
            return this;
        }

        public final void setAddressingType(String addressingType) {
            this.addressingType = addressingType;
        }

        public final Collection<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return this.blockDeviceMappings != null ? (Collection)this.blockDeviceMappings.stream().map(BlockDeviceMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder> ... blockDeviceMappings) {
            this.blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> (BlockDeviceMapping)((BlockDeviceMapping.Builder)BlockDeviceMapping.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final IamInstanceProfileSpecification.Builder getIamInstanceProfile() {
            return this.iamInstanceProfile != null ? this.iamInstanceProfile.toBuilder() : null;
        }

        @Override
        public final Builder iamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(IamInstanceProfileSpecification.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final Collection<InstanceNetworkInterfaceSpecification.Builder> getNetworkInterfaces() {
            return this.networkInterfaces != null ? (Collection)this.networkInterfaces.stream().map(InstanceNetworkInterfaceSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceSpecificationListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(InstanceNetworkInterfaceSpecification ... networkInterfaces) {
            this.networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<InstanceNetworkInterfaceSpecification.Builder> ... networkInterfaces) {
            this.networkInterfaces(Stream.of(networkInterfaces).map(c -> (InstanceNetworkInterfaceSpecification)((InstanceNetworkInterfaceSpecification.Builder)InstanceNetworkInterfaceSpecification.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkInterfaces(Collection<InstanceNetworkInterfaceSpecification.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceSpecificationListCopier.copyFromBuilder(networkInterfaces);
        }

        public final SpotPlacement.Builder getPlacement() {
            return this.placement != null ? this.placement.toBuilder() : null;
        }

        @Override
        public final Builder placement(SpotPlacement placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(SpotPlacement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        public final String getRamdiskId() {
            return this.ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final Collection<GroupIdentifier.Builder> getAllSecurityGroups() {
            return this.allSecurityGroups != null ? (Collection)this.allSecurityGroups.stream().map(GroupIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder allSecurityGroups(Collection<GroupIdentifier> allSecurityGroups) {
            this.allSecurityGroups = GroupIdentifierListCopier.copy(allSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allSecurityGroups(GroupIdentifier ... allSecurityGroups) {
            this.allSecurityGroups(Arrays.asList(allSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allSecurityGroups(Consumer<GroupIdentifier.Builder> ... allSecurityGroups) {
            this.allSecurityGroups(Stream.of(allSecurityGroups).map(c -> (GroupIdentifier)((GroupIdentifier.Builder)GroupIdentifier.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAllSecurityGroups(Collection<GroupIdentifier.BuilderImpl> allSecurityGroups) {
            this.allSecurityGroups = GroupIdentifierListCopier.copyFromBuilder(allSecurityGroups);
        }

        public final Boolean getMonitoringEnabled() {
            return this.monitoringEnabled;
        }

        @Override
        public final Builder monitoringEnabled(Boolean monitoringEnabled) {
            this.monitoringEnabled = monitoringEnabled;
            return this;
        }

        public final void setMonitoringEnabled(Boolean monitoringEnabled) {
            this.monitoringEnabled = monitoringEnabled;
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = GroupNameStringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = GroupNameStringListCopier.copy(securityGroups);
        }

        public LaunchSpecification build() {
            return new LaunchSpecification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LaunchSpecification> {
        public Builder userData(String var1);

        public Builder addressingType(String var1);

        public Builder blockDeviceMappings(Collection<BlockDeviceMapping> var1);

        public Builder blockDeviceMappings(BlockDeviceMapping ... var1);

        public Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder> ... var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder iamInstanceProfile(IamInstanceProfileSpecification var1);

        default public Builder iamInstanceProfile(Consumer<IamInstanceProfileSpecification.Builder> iamInstanceProfile) {
            return this.iamInstanceProfile((IamInstanceProfileSpecification)((IamInstanceProfileSpecification.Builder)IamInstanceProfileSpecification.builder().apply(iamInstanceProfile)).build());
        }

        public Builder imageId(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder kernelId(String var1);

        public Builder keyName(String var1);

        public Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> var1);

        public Builder networkInterfaces(InstanceNetworkInterfaceSpecification ... var1);

        public Builder networkInterfaces(Consumer<InstanceNetworkInterfaceSpecification.Builder> ... var1);

        public Builder placement(SpotPlacement var1);

        default public Builder placement(Consumer<SpotPlacement.Builder> placement) {
            return this.placement((SpotPlacement)((SpotPlacement.Builder)SpotPlacement.builder().apply(placement)).build());
        }

        public Builder ramdiskId(String var1);

        public Builder subnetId(String var1);

        public Builder allSecurityGroups(Collection<GroupIdentifier> var1);

        public Builder allSecurityGroups(GroupIdentifier ... var1);

        public Builder allSecurityGroups(Consumer<GroupIdentifier.Builder> ... var1);

        public Builder monitoringEnabled(Boolean var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);
    }
}

