/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.DiskImageDetail;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.VolumeDetail;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImportVolumeRequest
extends EC2Request
implements ToCopyableBuilder<Builder, ImportVolumeRequest> {
    private final String availabilityZone;
    private final String description;
    private final DiskImageDetail image;
    private final VolumeDetail volume;

    private ImportVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.availabilityZone = builder.availabilityZone;
        this.description = builder.description;
        this.image = builder.image;
        this.volume = builder.volume;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String description() {
        return this.description;
    }

    public DiskImageDetail image() {
        return this.image;
    }

    public VolumeDetail volume() {
        return this.volume;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.volume());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportVolumeRequest)) {
            return false;
        }
        ImportVolumeRequest other = (ImportVolumeRequest)((Object)obj);
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.volume(), other.volume());
    }

    public String toString() {
        return ToString.builder((String)"ImportVolumeRequest").add("AvailabilityZone", (Object)this.availabilityZone()).add("Description", (Object)this.description()).add("Image", (Object)this.image()).add("Volume", (Object)this.volume()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Image": {
                return Optional.of(clazz.cast(this.image()));
            }
            case "Volume": {
                return Optional.of(clazz.cast(this.volume()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String availabilityZone;
        private String description;
        private DiskImageDetail image;
        private VolumeDetail volume;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportVolumeRequest model) {
            super(model);
            this.availabilityZone(model.availabilityZone);
            this.description(model.description);
            this.image(model.image);
            this.volume(model.volume);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final DiskImageDetail.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        @Override
        public final Builder image(DiskImageDetail image) {
            this.image = image;
            return this;
        }

        public final void setImage(DiskImageDetail.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        public final VolumeDetail.Builder getVolume() {
            return this.volume != null ? this.volume.toBuilder() : null;
        }

        @Override
        public final Builder volume(VolumeDetail volume) {
            this.volume = volume;
            return this;
        }

        public final void setVolume(VolumeDetail.BuilderImpl volume) {
            this.volume = volume != null ? volume.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ImportVolumeRequest build() {
            return new ImportVolumeRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, ImportVolumeRequest> {
        public Builder availabilityZone(String var1);

        public Builder description(String var1);

        public Builder image(DiskImageDetail var1);

        default public Builder image(Consumer<DiskImageDetail.Builder> image) {
            return this.image((DiskImageDetail)((DiskImageDetail.Builder)DiskImageDetail.builder().apply(image)).build());
        }

        public Builder volume(VolumeDetail var1);

        default public Builder volume(Consumer<VolumeDetail.Builder> volume) {
            return this.volume((VolumeDetail)((VolumeDetail.Builder)VolumeDetail.builder().apply(volume)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

