/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ec2.model.AllocationState;
import software.amazon.awssdk.services.ec2.model.AutoPlacement;
import software.amazon.awssdk.services.ec2.model.AvailableCapacity;
import software.amazon.awssdk.services.ec2.model.HostInstance;
import software.amazon.awssdk.services.ec2.model.HostInstanceListCopier;
import software.amazon.awssdk.services.ec2.model.HostProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Host
implements ToCopyableBuilder<Builder, Host> {
    private final String autoPlacement;
    private final String availabilityZone;
    private final AvailableCapacity availableCapacity;
    private final String clientToken;
    private final String hostId;
    private final HostProperties hostProperties;
    private final String hostReservationId;
    private final List<HostInstance> instances;
    private final String state;

    private Host(BuilderImpl builder) {
        this.autoPlacement = builder.autoPlacement;
        this.availabilityZone = builder.availabilityZone;
        this.availableCapacity = builder.availableCapacity;
        this.clientToken = builder.clientToken;
        this.hostId = builder.hostId;
        this.hostProperties = builder.hostProperties;
        this.hostReservationId = builder.hostReservationId;
        this.instances = builder.instances;
        this.state = builder.state;
    }

    public AutoPlacement autoPlacement() {
        return AutoPlacement.fromValue(this.autoPlacement);
    }

    public String autoPlacementAsString() {
        return this.autoPlacement;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public AvailableCapacity availableCapacity() {
        return this.availableCapacity;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public String hostId() {
        return this.hostId;
    }

    public HostProperties hostProperties() {
        return this.hostProperties;
    }

    public String hostReservationId() {
        return this.hostReservationId;
    }

    public List<HostInstance> instances() {
        return this.instances;
    }

    public AllocationState state() {
        return AllocationState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoPlacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instances());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Host)) {
            return false;
        }
        Host other = (Host)obj;
        return Objects.equals(this.autoPlacementAsString(), other.autoPlacementAsString()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.availableCapacity(), other.availableCapacity()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.hostId(), other.hostId()) && Objects.equals(this.hostProperties(), other.hostProperties()) && Objects.equals(this.hostReservationId(), other.hostReservationId()) && Objects.equals(this.instances(), other.instances()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public String toString() {
        return ToString.builder((String)"Host").add("AutoPlacement", (Object)this.autoPlacementAsString()).add("AvailabilityZone", (Object)this.availabilityZone()).add("AvailableCapacity", (Object)this.availableCapacity()).add("ClientToken", (Object)this.clientToken()).add("HostId", (Object)this.hostId()).add("HostProperties", (Object)this.hostProperties()).add("HostReservationId", (Object)this.hostReservationId()).add("Instances", this.instances()).add("State", (Object)this.stateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoPlacement": {
                return Optional.of(clazz.cast(this.autoPlacementAsString()));
            }
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "AvailableCapacity": {
                return Optional.of(clazz.cast(this.availableCapacity()));
            }
            case "ClientToken": {
                return Optional.of(clazz.cast(this.clientToken()));
            }
            case "HostId": {
                return Optional.of(clazz.cast(this.hostId()));
            }
            case "HostProperties": {
                return Optional.of(clazz.cast(this.hostProperties()));
            }
            case "HostReservationId": {
                return Optional.of(clazz.cast(this.hostReservationId()));
            }
            case "Instances": {
                return Optional.of(clazz.cast(this.instances()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String autoPlacement;
        private String availabilityZone;
        private AvailableCapacity availableCapacity;
        private String clientToken;
        private String hostId;
        private HostProperties hostProperties;
        private String hostReservationId;
        private List<HostInstance> instances;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(Host model) {
            this.autoPlacement(model.autoPlacement);
            this.availabilityZone(model.availabilityZone);
            this.availableCapacity(model.availableCapacity);
            this.clientToken(model.clientToken);
            this.hostId(model.hostId);
            this.hostProperties(model.hostProperties);
            this.hostReservationId(model.hostReservationId);
            this.instances(model.instances);
            this.state(model.state);
        }

        public final String getAutoPlacement() {
            return this.autoPlacement;
        }

        @Override
        public final Builder autoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
            return this;
        }

        @Override
        public final Builder autoPlacement(AutoPlacement autoPlacement) {
            this.autoPlacement(autoPlacement.toString());
            return this;
        }

        public final void setAutoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final AvailableCapacity.Builder getAvailableCapacity() {
            return this.availableCapacity != null ? this.availableCapacity.toBuilder() : null;
        }

        @Override
        public final Builder availableCapacity(AvailableCapacity availableCapacity) {
            this.availableCapacity = availableCapacity;
            return this;
        }

        public final void setAvailableCapacity(AvailableCapacity.BuilderImpl availableCapacity) {
            this.availableCapacity = availableCapacity != null ? availableCapacity.build() : null;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getHostId() {
            return this.hostId;
        }

        @Override
        public final Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        public final void setHostId(String hostId) {
            this.hostId = hostId;
        }

        public final HostProperties.Builder getHostProperties() {
            return this.hostProperties != null ? this.hostProperties.toBuilder() : null;
        }

        @Override
        public final Builder hostProperties(HostProperties hostProperties) {
            this.hostProperties = hostProperties;
            return this;
        }

        public final void setHostProperties(HostProperties.BuilderImpl hostProperties) {
            this.hostProperties = hostProperties != null ? hostProperties.build() : null;
        }

        public final String getHostReservationId() {
            return this.hostReservationId;
        }

        @Override
        public final Builder hostReservationId(String hostReservationId) {
            this.hostReservationId = hostReservationId;
            return this;
        }

        public final void setHostReservationId(String hostReservationId) {
            this.hostReservationId = hostReservationId;
        }

        public final Collection<HostInstance.Builder> getInstances() {
            return this.instances != null ? (Collection)this.instances.stream().map(HostInstance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instances(Collection<HostInstance> instances) {
            this.instances = HostInstanceListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(HostInstance ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<HostInstance.Builder> ... instances) {
            this.instances(Stream.of(instances).map(c -> (HostInstance)((HostInstance.Builder)HostInstance.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstances(Collection<HostInstance.BuilderImpl> instances) {
            this.instances = HostInstanceListCopier.copyFromBuilder(instances);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AllocationState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public Host build() {
            return new Host(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Host> {
        public Builder autoPlacement(String var1);

        public Builder autoPlacement(AutoPlacement var1);

        public Builder availabilityZone(String var1);

        public Builder availableCapacity(AvailableCapacity var1);

        default public Builder availableCapacity(Consumer<AvailableCapacity.Builder> availableCapacity) {
            return this.availableCapacity((AvailableCapacity)((AvailableCapacity.Builder)AvailableCapacity.builder().apply(availableCapacity)).build());
        }

        public Builder clientToken(String var1);

        public Builder hostId(String var1);

        public Builder hostProperties(HostProperties var1);

        default public Builder hostProperties(Consumer<HostProperties.Builder> hostProperties) {
            return this.hostProperties((HostProperties)((HostProperties.Builder)HostProperties.builder().apply(hostProperties)).build());
        }

        public Builder hostReservationId(String var1);

        public Builder instances(Collection<HostInstance> var1);

        public Builder instances(HostInstance ... var1);

        public Builder instances(Consumer<HostInstance.Builder> ... var1);

        public Builder state(String var1);

        public Builder state(AllocationState var1);
    }
}

