/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ec2.model.LoadPermission;
import software.amazon.awssdk.services.ec2.model.LoadPermissionListCopier;
import software.amazon.awssdk.services.ec2.model.ProductCode;
import software.amazon.awssdk.services.ec2.model.ProductCodeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FpgaImageAttribute
implements ToCopyableBuilder<Builder, FpgaImageAttribute> {
    private final String fpgaImageId;
    private final String name;
    private final String description;
    private final List<LoadPermission> loadPermissions;
    private final List<ProductCode> productCodes;

    private FpgaImageAttribute(BuilderImpl builder) {
        this.fpgaImageId = builder.fpgaImageId;
        this.name = builder.name;
        this.description = builder.description;
        this.loadPermissions = builder.loadPermissions;
        this.productCodes = builder.productCodes;
    }

    public String fpgaImageId() {
        return this.fpgaImageId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public List<LoadPermission> loadPermissions() {
        return this.loadPermissions;
    }

    public List<ProductCode> productCodes() {
        return this.productCodes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fpgaImageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.productCodes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FpgaImageAttribute)) {
            return false;
        }
        FpgaImageAttribute other = (FpgaImageAttribute)obj;
        return Objects.equals(this.fpgaImageId(), other.fpgaImageId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.loadPermissions(), other.loadPermissions()) && Objects.equals(this.productCodes(), other.productCodes());
    }

    public String toString() {
        return ToString.builder((String)"FpgaImageAttribute").add("FpgaImageId", (Object)this.fpgaImageId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("LoadPermissions", this.loadPermissions()).add("ProductCodes", this.productCodes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FpgaImageId": {
                return Optional.of(clazz.cast(this.fpgaImageId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "LoadPermissions": {
                return Optional.of(clazz.cast(this.loadPermissions()));
            }
            case "ProductCodes": {
                return Optional.of(clazz.cast(this.productCodes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String fpgaImageId;
        private String name;
        private String description;
        private List<LoadPermission> loadPermissions;
        private List<ProductCode> productCodes;

        private BuilderImpl() {
        }

        private BuilderImpl(FpgaImageAttribute model) {
            this.fpgaImageId(model.fpgaImageId);
            this.name(model.name);
            this.description(model.description);
            this.loadPermissions(model.loadPermissions);
            this.productCodes(model.productCodes);
        }

        public final String getFpgaImageId() {
            return this.fpgaImageId;
        }

        @Override
        public final Builder fpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
            return this;
        }

        public final void setFpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<LoadPermission.Builder> getLoadPermissions() {
            return this.loadPermissions != null ? (Collection)this.loadPermissions.stream().map(LoadPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder loadPermissions(Collection<LoadPermission> loadPermissions) {
            this.loadPermissions = LoadPermissionListCopier.copy(loadPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadPermissions(LoadPermission ... loadPermissions) {
            this.loadPermissions(Arrays.asList(loadPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadPermissions(Consumer<LoadPermission.Builder> ... loadPermissions) {
            this.loadPermissions(Stream.of(loadPermissions).map(c -> (LoadPermission)((LoadPermission.Builder)LoadPermission.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLoadPermissions(Collection<LoadPermission.BuilderImpl> loadPermissions) {
            this.loadPermissions = LoadPermissionListCopier.copyFromBuilder(loadPermissions);
        }

        public final Collection<ProductCode.Builder> getProductCodes() {
            return this.productCodes != null ? (Collection)this.productCodes.stream().map(ProductCode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode ... productCodes) {
            this.productCodes(Arrays.asList(productCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(Consumer<ProductCode.Builder> ... productCodes) {
            this.productCodes(Stream.of(productCodes).map(c -> (ProductCode)((ProductCode.Builder)ProductCode.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        public FpgaImageAttribute build() {
            return new FpgaImageAttribute(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FpgaImageAttribute> {
        public Builder fpgaImageId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder loadPermissions(Collection<LoadPermission> var1);

        public Builder loadPermissions(LoadPermission ... var1);

        public Builder loadPermissions(Consumer<LoadPermission.Builder> ... var1);

        public Builder productCodes(Collection<ProductCode> var1);

        public Builder productCodes(ProductCode ... var1);

        public Builder productCodes(Consumer<ProductCode.Builder> ... var1);
    }
}

