/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ec2.model.DhcpConfiguration;
import software.amazon.awssdk.services.ec2.model.DhcpConfigurationListCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DhcpOptions
implements ToCopyableBuilder<Builder, DhcpOptions> {
    private final List<DhcpConfiguration> dhcpConfigurations;
    private final String dhcpOptionsId;
    private final List<Tag> tags;

    private DhcpOptions(BuilderImpl builder) {
        this.dhcpConfigurations = builder.dhcpConfigurations;
        this.dhcpOptionsId = builder.dhcpOptionsId;
        this.tags = builder.tags;
    }

    public List<DhcpConfiguration> dhcpConfigurations() {
        return this.dhcpConfigurations;
    }

    public String dhcpOptionsId() {
        return this.dhcpOptionsId;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dhcpConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.dhcpOptionsId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DhcpOptions)) {
            return false;
        }
        DhcpOptions other = (DhcpOptions)obj;
        return Objects.equals(this.dhcpConfigurations(), other.dhcpConfigurations()) && Objects.equals(this.dhcpOptionsId(), other.dhcpOptionsId()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"DhcpOptions").add("DhcpConfigurations", this.dhcpConfigurations()).add("DhcpOptionsId", (Object)this.dhcpOptionsId()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DhcpConfigurations": {
                return Optional.of(clazz.cast(this.dhcpConfigurations()));
            }
            case "DhcpOptionsId": {
                return Optional.of(clazz.cast(this.dhcpOptionsId()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<DhcpConfiguration> dhcpConfigurations;
        private String dhcpOptionsId;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(DhcpOptions model) {
            this.dhcpConfigurations(model.dhcpConfigurations);
            this.dhcpOptionsId(model.dhcpOptionsId);
            this.tags(model.tags);
        }

        public final Collection<DhcpConfiguration.Builder> getDhcpConfigurations() {
            return this.dhcpConfigurations != null ? (Collection)this.dhcpConfigurations.stream().map(DhcpConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dhcpConfigurations(Collection<DhcpConfiguration> dhcpConfigurations) {
            this.dhcpConfigurations = DhcpConfigurationListCopier.copy(dhcpConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dhcpConfigurations(DhcpConfiguration ... dhcpConfigurations) {
            this.dhcpConfigurations(Arrays.asList(dhcpConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dhcpConfigurations(Consumer<DhcpConfiguration.Builder> ... dhcpConfigurations) {
            this.dhcpConfigurations(Stream.of(dhcpConfigurations).map(c -> (DhcpConfiguration)((DhcpConfiguration.Builder)DhcpConfiguration.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDhcpConfigurations(Collection<DhcpConfiguration.BuilderImpl> dhcpConfigurations) {
            this.dhcpConfigurations = DhcpConfigurationListCopier.copyFromBuilder(dhcpConfigurations);
        }

        public final String getDhcpOptionsId() {
            return this.dhcpOptionsId;
        }

        @Override
        public final Builder dhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
            return this;
        }

        public final void setDhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public DhcpOptions build() {
            return new DhcpOptions(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DhcpOptions> {
        public Builder dhcpConfigurations(Collection<DhcpConfiguration> var1);

        public Builder dhcpConfigurations(DhcpConfiguration ... var1);

        public Builder dhcpConfigurations(Consumer<DhcpConfiguration.Builder> ... var1);

        public Builder dhcpOptionsId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

