/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.ProductCode;
import software.amazon.awssdk.services.ec2.model.ProductCodeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVolumeAttributeResponse
extends EC2Response
implements ToCopyableBuilder<Builder, DescribeVolumeAttributeResponse> {
    private final Boolean autoEnableIO;
    private final List<ProductCode> productCodes;
    private final String volumeId;

    private DescribeVolumeAttributeResponse(BuilderImpl builder) {
        super(builder);
        this.autoEnableIO = builder.autoEnableIO;
        this.productCodes = builder.productCodes;
        this.volumeId = builder.volumeId;
    }

    public Boolean autoEnableIO() {
        return this.autoEnableIO;
    }

    public List<ProductCode> productCodes() {
        return this.productCodes;
    }

    public String volumeId() {
        return this.volumeId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoEnableIO());
        hashCode = 31 * hashCode + Objects.hashCode(this.productCodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumeAttributeResponse)) {
            return false;
        }
        DescribeVolumeAttributeResponse other = (DescribeVolumeAttributeResponse)((Object)obj);
        return Objects.equals(this.autoEnableIO(), other.autoEnableIO()) && Objects.equals(this.productCodes(), other.productCodes()) && Objects.equals(this.volumeId(), other.volumeId());
    }

    public String toString() {
        return ToString.builder((String)"DescribeVolumeAttributeResponse").add("AutoEnableIO", (Object)this.autoEnableIO()).add("ProductCodes", this.productCodes()).add("VolumeId", (Object)this.volumeId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoEnableIO": {
                return Optional.of(clazz.cast(this.autoEnableIO()));
            }
            case "ProductCodes": {
                return Optional.of(clazz.cast(this.productCodes()));
            }
            case "VolumeId": {
                return Optional.of(clazz.cast(this.volumeId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private Boolean autoEnableIO;
        private List<ProductCode> productCodes;
        private String volumeId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumeAttributeResponse model) {
            super(model);
            this.autoEnableIO(model.autoEnableIO);
            this.productCodes(model.productCodes);
            this.volumeId(model.volumeId);
        }

        public final Boolean getAutoEnableIO() {
            return this.autoEnableIO;
        }

        @Override
        public final Builder autoEnableIO(Boolean autoEnableIO) {
            this.autoEnableIO = autoEnableIO;
            return this;
        }

        public final void setAutoEnableIO(Boolean autoEnableIO) {
            this.autoEnableIO = autoEnableIO;
        }

        public final Collection<ProductCode.Builder> getProductCodes() {
            return this.productCodes != null ? (Collection)this.productCodes.stream().map(ProductCode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode ... productCodes) {
            this.productCodes(Arrays.asList(productCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(Consumer<ProductCode.Builder> ... productCodes) {
            this.productCodes(Stream.of(productCodes).map(c -> (ProductCode)((ProductCode.Builder)ProductCode.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public DescribeVolumeAttributeResponse build() {
            return new DescribeVolumeAttributeResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, DescribeVolumeAttributeResponse> {
        public Builder autoEnableIO(Boolean var1);

        public Builder productCodes(Collection<ProductCode> var1);

        public Builder productCodes(ProductCode ... var1);

        public Builder productCodes(Consumer<ProductCode.Builder> ... var1);

        public Builder volumeId(String var1);
    }
}

