/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.EgressOnlyInternetGateway;
import software.amazon.awssdk.services.ec2.model.EgressOnlyInternetGatewayListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEgressOnlyInternetGatewaysResponse
extends EC2Response
implements ToCopyableBuilder<Builder, DescribeEgressOnlyInternetGatewaysResponse> {
    private final List<EgressOnlyInternetGateway> egressOnlyInternetGateways;
    private final String nextToken;

    private DescribeEgressOnlyInternetGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.egressOnlyInternetGateways = builder.egressOnlyInternetGateways;
        this.nextToken = builder.nextToken;
    }

    public List<EgressOnlyInternetGateway> egressOnlyInternetGateways() {
        return this.egressOnlyInternetGateways;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.egressOnlyInternetGateways());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEgressOnlyInternetGatewaysResponse)) {
            return false;
        }
        DescribeEgressOnlyInternetGatewaysResponse other = (DescribeEgressOnlyInternetGatewaysResponse)((Object)obj);
        return Objects.equals(this.egressOnlyInternetGateways(), other.egressOnlyInternetGateways()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEgressOnlyInternetGatewaysResponse").add("EgressOnlyInternetGateways", this.egressOnlyInternetGateways()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EgressOnlyInternetGateways": {
                return Optional.of(clazz.cast(this.egressOnlyInternetGateways()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private List<EgressOnlyInternetGateway> egressOnlyInternetGateways;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEgressOnlyInternetGatewaysResponse model) {
            super(model);
            this.egressOnlyInternetGateways(model.egressOnlyInternetGateways);
            this.nextToken(model.nextToken);
        }

        public final Collection<EgressOnlyInternetGateway.Builder> getEgressOnlyInternetGateways() {
            return this.egressOnlyInternetGateways != null ? (Collection)this.egressOnlyInternetGateways.stream().map(EgressOnlyInternetGateway::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder egressOnlyInternetGateways(Collection<EgressOnlyInternetGateway> egressOnlyInternetGateways) {
            this.egressOnlyInternetGateways = EgressOnlyInternetGatewayListCopier.copy(egressOnlyInternetGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder egressOnlyInternetGateways(EgressOnlyInternetGateway ... egressOnlyInternetGateways) {
            this.egressOnlyInternetGateways(Arrays.asList(egressOnlyInternetGateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder egressOnlyInternetGateways(Consumer<EgressOnlyInternetGateway.Builder> ... egressOnlyInternetGateways) {
            this.egressOnlyInternetGateways(Stream.of(egressOnlyInternetGateways).map(c -> (EgressOnlyInternetGateway)((EgressOnlyInternetGateway.Builder)EgressOnlyInternetGateway.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEgressOnlyInternetGateways(Collection<EgressOnlyInternetGateway.BuilderImpl> egressOnlyInternetGateways) {
            this.egressOnlyInternetGateways = EgressOnlyInternetGatewayListCopier.copyFromBuilder(egressOnlyInternetGateways);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeEgressOnlyInternetGatewaysResponse build() {
            return new DescribeEgressOnlyInternetGatewaysResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, DescribeEgressOnlyInternetGatewaysResponse> {
        public Builder egressOnlyInternetGateways(Collection<EgressOnlyInternetGateway> var1);

        public Builder egressOnlyInternetGateways(EgressOnlyInternetGateway ... var1);

        public Builder egressOnlyInternetGateways(Consumer<EgressOnlyInternetGateway.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

