/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AttachNetworkInterfaceRequest
extends EC2Request
implements ToCopyableBuilder<Builder, AttachNetworkInterfaceRequest> {
    private final Integer deviceIndex;
    private final String instanceId;
    private final String networkInterfaceId;

    private AttachNetworkInterfaceRequest(BuilderImpl builder) {
        super(builder);
        this.deviceIndex = builder.deviceIndex;
        this.instanceId = builder.instanceId;
        this.networkInterfaceId = builder.networkInterfaceId;
    }

    public Integer deviceIndex() {
        return this.deviceIndex;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachNetworkInterfaceRequest)) {
            return false;
        }
        AttachNetworkInterfaceRequest other = (AttachNetworkInterfaceRequest)((Object)obj);
        return Objects.equals(this.deviceIndex(), other.deviceIndex()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId());
    }

    public String toString() {
        return ToString.builder((String)"AttachNetworkInterfaceRequest").add("DeviceIndex", (Object)this.deviceIndex()).add("InstanceId", (Object)this.instanceId()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceIndex": {
                return Optional.of(clazz.cast(this.deviceIndex()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "NetworkInterfaceId": {
                return Optional.of(clazz.cast(this.networkInterfaceId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private Integer deviceIndex;
        private String instanceId;
        private String networkInterfaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachNetworkInterfaceRequest model) {
            super(model);
            this.deviceIndex(model.deviceIndex);
            this.instanceId(model.instanceId);
            this.networkInterfaceId(model.networkInterfaceId);
        }

        public final Integer getDeviceIndex() {
            return this.deviceIndex;
        }

        @Override
        public final Builder deviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
            return this;
        }

        public final void setDeviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AttachNetworkInterfaceRequest build() {
            return new AttachNetworkInterfaceRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, AttachNetworkInterfaceRequest> {
        public Builder deviceIndex(Integer var1);

        public Builder instanceId(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

