/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.DomainType;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AllocateAddressRequest
extends EC2Request
implements ToCopyableBuilder<Builder, AllocateAddressRequest> {
    private final String domain;
    private final String address;

    private AllocateAddressRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.address = builder.address;
    }

    public DomainType domain() {
        return DomainType.fromValue(this.domain);
    }

    public String domainAsString() {
        return this.domain;
    }

    public String address() {
        return this.address;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateAddressRequest)) {
            return false;
        }
        AllocateAddressRequest other = (AllocateAddressRequest)((Object)obj);
        return Objects.equals(this.domainAsString(), other.domainAsString()) && Objects.equals(this.address(), other.address());
    }

    public String toString() {
        return ToString.builder((String)"AllocateAddressRequest").add("Domain", (Object)this.domainAsString()).add("Address", (Object)this.address()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Domain": {
                return Optional.of(clazz.cast(this.domainAsString()));
            }
            case "Address": {
                return Optional.of(clazz.cast(this.address()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String domain;
        private String address;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateAddressRequest model) {
            super(model);
            this.domain(model.domain);
            this.address(model.address);
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public final Builder domain(DomainType domain) {
            this.domain(domain.toString());
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getAddress() {
            return this.address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AllocateAddressRequest build() {
            return new AllocateAddressRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, AllocateAddressRequest> {
        public Builder domain(String var1);

        public Builder domain(DomainType var1);

        public Builder address(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

