/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * SpotFleetRequestConfigData StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class SpotFleetRequestConfigDataUnmarshaller implements Unmarshaller<SpotFleetRequestConfigData, StaxUnmarshallerContext> {

    public SpotFleetRequestConfigData unmarshall(StaxUnmarshallerContext context) throws Exception {
        SpotFleetRequestConfigData.Builder spotFleetRequestConfigData = SpotFleetRequestConfigData.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<SpotFleetLaunchSpecification> launchSpecifications = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                spotFleetRequestConfigData.launchSpecifications(launchSpecifications);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("allocationStrategy", targetDepth)) {
                    spotFleetRequestConfigData.allocationStrategy(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("clientToken", targetDepth)) {
                    spotFleetRequestConfigData.clientToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("excessCapacityTerminationPolicy", targetDepth)) {
                    spotFleetRequestConfigData.excessCapacityTerminationPolicy(StringUnmarshaller.getInstance().unmarshall(
                            context));
                    continue;
                }

                if (context.testExpression("fulfilledCapacity", targetDepth)) {
                    spotFleetRequestConfigData.fulfilledCapacity(DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("iamFleetRole", targetDepth)) {
                    spotFleetRequestConfigData.iamFleetRole(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("launchSpecifications", targetDepth)) {
                    launchSpecifications = new ArrayList<SpotFleetLaunchSpecification>();
                    continue;
                }

                if (context.testExpression("launchSpecifications/item", targetDepth)) {
                    launchSpecifications.add(SpotFleetLaunchSpecificationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("spotPrice", targetDepth)) {
                    spotFleetRequestConfigData.spotPrice(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("targetCapacity", targetDepth)) {
                    spotFleetRequestConfigData.targetCapacity(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("terminateInstancesWithExpiration", targetDepth)) {
                    spotFleetRequestConfigData.terminateInstancesWithExpiration(BooleanUnmarshaller.getInstance().unmarshall(
                            context));
                    continue;
                }

                if (context.testExpression("type", targetDepth)) {
                    spotFleetRequestConfigData.type(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("validFrom", targetDepth)) {
                    spotFleetRequestConfigData.validFrom(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("validUntil", targetDepth)) {
                    spotFleetRequestConfigData.validUntil(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("replaceUnhealthyInstances", targetDepth)) {
                    spotFleetRequestConfigData.replaceUnhealthyInstances(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("instanceInterruptionBehavior", targetDepth)) {
                    spotFleetRequestConfigData.instanceInterruptionBehavior(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("loadBalancersConfig", targetDepth)) {
                    spotFleetRequestConfigData.loadBalancersConfig(LoadBalancersConfigUnmarshaller.getInstance().unmarshall(
                            context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    spotFleetRequestConfigData.launchSpecifications(launchSpecifications);
                    break;
                }
            }
        }
        return spotFleetRequestConfigData.build();
    }

    private static final SpotFleetRequestConfigDataUnmarshaller INSTANCE = new SpotFleetRequestConfigDataUnmarshaller();

    public static SpotFleetRequestConfigDataUnmarshaller getInstance() {
        return INSTANCE;
    }
}
