/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * ScheduledInstanceRecurrenceRequest StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ScheduledInstanceRecurrenceRequestUnmarshaller implements
        Unmarshaller<ScheduledInstanceRecurrenceRequest, StaxUnmarshallerContext> {

    public ScheduledInstanceRecurrenceRequest unmarshall(StaxUnmarshallerContext context) throws Exception {
        ScheduledInstanceRecurrenceRequest.Builder scheduledInstanceRecurrenceRequest = ScheduledInstanceRecurrenceRequest
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<Integer> occurrenceDays = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                scheduledInstanceRecurrenceRequest.occurrenceDays(occurrenceDays);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Frequency", targetDepth)) {
                    scheduledInstanceRecurrenceRequest.frequency(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Interval", targetDepth)) {
                    scheduledInstanceRecurrenceRequest.interval(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("OccurrenceDay", targetDepth)) {
                    occurrenceDays = new ArrayList<Integer>();
                    continue;
                }

                if (context.testExpression("OccurrenceDay/OccurenceDay", targetDepth)) {
                    occurrenceDays.add(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("OccurrenceRelativeToEnd", targetDepth)) {
                    scheduledInstanceRecurrenceRequest.occurrenceRelativeToEnd(BooleanUnmarshaller.getInstance().unmarshall(
                            context));
                    continue;
                }

                if (context.testExpression("OccurrenceUnit", targetDepth)) {
                    scheduledInstanceRecurrenceRequest.occurrenceUnit(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    scheduledInstanceRecurrenceRequest.occurrenceDays(occurrenceDays);
                    break;
                }
            }
        }
        return scheduledInstanceRecurrenceRequest.build();
    }

    private static final ScheduledInstanceRecurrenceRequestUnmarshaller INSTANCE = new ScheduledInstanceRecurrenceRequestUnmarshaller();

    public static ScheduledInstanceRecurrenceRequestUnmarshaller getInstance() {
        return INSTANCE;
    }
}
