/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * ReservedInstances StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ReservedInstancesUnmarshaller implements Unmarshaller<ReservedInstances, StaxUnmarshallerContext> {

    public ReservedInstances unmarshall(StaxUnmarshallerContext context) throws Exception {
        ReservedInstances.Builder reservedInstances = ReservedInstances.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<RecurringCharge> recurringCharges = null;
        java.util.List<Tag> tags = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                reservedInstances.recurringCharges(recurringCharges);
                reservedInstances.tags(tags);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("availabilityZone", targetDepth)) {
                    reservedInstances.availabilityZone(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("duration", targetDepth)) {
                    reservedInstances.duration(LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("end", targetDepth)) {
                    reservedInstances.end(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("fixedPrice", targetDepth)) {
                    reservedInstances.fixedPrice(FloatUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("instanceCount", targetDepth)) {
                    reservedInstances.instanceCount(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("instanceType", targetDepth)) {
                    reservedInstances.instanceType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("productDescription", targetDepth)) {
                    reservedInstances.productDescription(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("reservedInstancesId", targetDepth)) {
                    reservedInstances.reservedInstancesId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("start", targetDepth)) {
                    reservedInstances.start(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("state", targetDepth)) {
                    reservedInstances.state(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("usagePrice", targetDepth)) {
                    reservedInstances.usagePrice(FloatUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("currencyCode", targetDepth)) {
                    reservedInstances.currencyCode(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("instanceTenancy", targetDepth)) {
                    reservedInstances.instanceTenancy(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("offeringClass", targetDepth)) {
                    reservedInstances.offeringClass(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("offeringType", targetDepth)) {
                    reservedInstances.offeringType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("recurringCharges", targetDepth)) {
                    recurringCharges = new ArrayList<RecurringCharge>();
                    continue;
                }

                if (context.testExpression("recurringCharges/item", targetDepth)) {
                    recurringCharges.add(RecurringChargeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("scope", targetDepth)) {
                    reservedInstances.scope(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("tagSet", targetDepth)) {
                    tags = new ArrayList<Tag>();
                    continue;
                }

                if (context.testExpression("tagSet/item", targetDepth)) {
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    reservedInstances.recurringCharges(recurringCharges);
                    reservedInstances.tags(tags);
                    break;
                }
            }
        }
        return reservedInstances.build();
    }

    private static final ReservedInstancesUnmarshaller INSTANCE = new ReservedInstancesUnmarshaller();

    public static ReservedInstancesUnmarshaller getInstance() {
        return INSTANCE;
    }
}
