/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * ReplaceIamInstanceProfileAssociationRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ReplaceIamInstanceProfileAssociationRequestMarshaller implements
        Marshaller<Request<ReplaceIamInstanceProfileAssociationRequest>, ReplaceIamInstanceProfileAssociationRequest> {

    public Request<ReplaceIamInstanceProfileAssociationRequest> marshall(
            ReplaceIamInstanceProfileAssociationRequest replaceIamInstanceProfileAssociationRequest) {

        if (replaceIamInstanceProfileAssociationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ReplaceIamInstanceProfileAssociationRequest> request = new DefaultRequest<ReplaceIamInstanceProfileAssociationRequest>(
                replaceIamInstanceProfileAssociationRequest, "EC2Client");
        request.addParameter("Action", "ReplaceIamInstanceProfileAssociation");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        IamInstanceProfileSpecification iamInstanceProfile = replaceIamInstanceProfileAssociationRequest.iamInstanceProfile();
        if (iamInstanceProfile != null) {

            if (iamInstanceProfile.arn() != null) {
                request.addParameter("IamInstanceProfile.Arn", StringUtils.fromString(iamInstanceProfile.arn()));
            }

            if (iamInstanceProfile.name() != null) {
                request.addParameter("IamInstanceProfile.Name", StringUtils.fromString(iamInstanceProfile.name()));
            }
        }

        if (replaceIamInstanceProfileAssociationRequest.associationId() != null) {
            request.addParameter("AssociationId",
                    StringUtils.fromString(replaceIamInstanceProfileAssociationRequest.associationId()));
        }

        return request;
    }

}
