/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * NetworkAclEntry StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class NetworkAclEntryUnmarshaller implements Unmarshaller<NetworkAclEntry, StaxUnmarshallerContext> {

    public NetworkAclEntry unmarshall(StaxUnmarshallerContext context) throws Exception {
        NetworkAclEntry.Builder networkAclEntry = NetworkAclEntry.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("cidrBlock", targetDepth)) {
                    networkAclEntry.cidrBlock(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("egress", targetDepth)) {
                    networkAclEntry.egress(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("icmpTypeCode", targetDepth)) {
                    networkAclEntry.icmpTypeCode(IcmpTypeCodeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ipv6CidrBlock", targetDepth)) {
                    networkAclEntry.ipv6CidrBlock(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("portRange", targetDepth)) {
                    networkAclEntry.portRange(PortRangeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("protocol", targetDepth)) {
                    networkAclEntry.protocol(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ruleAction", targetDepth)) {
                    networkAclEntry.ruleAction(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ruleNumber", targetDepth)) {
                    networkAclEntry.ruleNumber(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    break;
                }
            }
        }
        return networkAclEntry.build();
    }

    private static final NetworkAclEntryUnmarshaller INSTANCE = new NetworkAclEntryUnmarshaller();

    public static NetworkAclEntryUnmarshaller getInstance() {
        return INSTANCE;
    }
}
