/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * ModifyNetworkInterfaceAttributeRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ModifyNetworkInterfaceAttributeRequestMarshaller implements
        Marshaller<Request<ModifyNetworkInterfaceAttributeRequest>, ModifyNetworkInterfaceAttributeRequest> {

    public Request<ModifyNetworkInterfaceAttributeRequest> marshall(
            ModifyNetworkInterfaceAttributeRequest modifyNetworkInterfaceAttributeRequest) {

        if (modifyNetworkInterfaceAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ModifyNetworkInterfaceAttributeRequest> request = new DefaultRequest<ModifyNetworkInterfaceAttributeRequest>(
                modifyNetworkInterfaceAttributeRequest, "EC2Client");
        request.addParameter("Action", "ModifyNetworkInterfaceAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        NetworkInterfaceAttachmentChanges attachment = modifyNetworkInterfaceAttributeRequest.attachment();
        if (attachment != null) {

            if (attachment.attachmentId() != null) {
                request.addParameter("Attachment.AttachmentId", StringUtils.fromString(attachment.attachmentId()));
            }

            if (attachment.deleteOnTermination() != null) {
                request.addParameter("Attachment.DeleteOnTermination", StringUtils.fromBoolean(attachment.deleteOnTermination()));
            }
        }

        if (modifyNetworkInterfaceAttributeRequest.description() != null) {
            request.addParameter("Description.Value",
                    StringUtils.fromString(modifyNetworkInterfaceAttributeRequest.description()));
        }

        java.util.List<String> modifyNetworkInterfaceAttributeRequestGroupsList = modifyNetworkInterfaceAttributeRequest.groups();
        if (modifyNetworkInterfaceAttributeRequestGroupsList != null) {
            int groupsListIndex = 1;

            for (String modifyNetworkInterfaceAttributeRequestGroupsListValue : modifyNetworkInterfaceAttributeRequestGroupsList) {
                if (modifyNetworkInterfaceAttributeRequestGroupsListValue != null) {
                    request.addParameter("SecurityGroupId." + groupsListIndex,
                            StringUtils.fromString(modifyNetworkInterfaceAttributeRequestGroupsListValue));
                }
                groupsListIndex++;
            }
        }

        if (modifyNetworkInterfaceAttributeRequest.networkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId",
                    StringUtils.fromString(modifyNetworkInterfaceAttributeRequest.networkInterfaceId()));
        }

        if (modifyNetworkInterfaceAttributeRequest.sourceDestCheck() != null) {
            request.addParameter("SourceDestCheck.Value",
                    StringUtils.fromBoolean(modifyNetworkInterfaceAttributeRequest.sourceDestCheck()));
        }

        return request;
    }

}
