/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * ModifyFpgaImageAttributeRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ModifyFpgaImageAttributeRequestMarshaller implements
        Marshaller<Request<ModifyFpgaImageAttributeRequest>, ModifyFpgaImageAttributeRequest> {

    public Request<ModifyFpgaImageAttributeRequest> marshall(ModifyFpgaImageAttributeRequest modifyFpgaImageAttributeRequest) {

        if (modifyFpgaImageAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ModifyFpgaImageAttributeRequest> request = new DefaultRequest<ModifyFpgaImageAttributeRequest>(
                modifyFpgaImageAttributeRequest, "EC2Client");
        request.addParameter("Action", "ModifyFpgaImageAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (modifyFpgaImageAttributeRequest.fpgaImageId() != null) {
            request.addParameter("FpgaImageId", StringUtils.fromString(modifyFpgaImageAttributeRequest.fpgaImageId()));
        }

        if (modifyFpgaImageAttributeRequest.attributeAsString() != null) {
            request.addParameter("Attribute", StringUtils.fromString(modifyFpgaImageAttributeRequest.attributeAsString()));
        }

        if (modifyFpgaImageAttributeRequest.operationTypeAsString() != null) {
            request.addParameter("OperationType", StringUtils.fromString(modifyFpgaImageAttributeRequest.operationTypeAsString()));
        }

        java.util.List<String> modifyFpgaImageAttributeRequestUserIdsList = modifyFpgaImageAttributeRequest.userIds();
        if (modifyFpgaImageAttributeRequestUserIdsList != null) {
            int userIdsListIndex = 1;

            for (String modifyFpgaImageAttributeRequestUserIdsListValue : modifyFpgaImageAttributeRequestUserIdsList) {
                if (modifyFpgaImageAttributeRequestUserIdsListValue != null) {
                    request.addParameter("UserId." + userIdsListIndex,
                            StringUtils.fromString(modifyFpgaImageAttributeRequestUserIdsListValue));
                }
                userIdsListIndex++;
            }
        }

        java.util.List<String> modifyFpgaImageAttributeRequestUserGroupsList = modifyFpgaImageAttributeRequest.userGroups();
        if (modifyFpgaImageAttributeRequestUserGroupsList != null) {
            int userGroupsListIndex = 1;

            for (String modifyFpgaImageAttributeRequestUserGroupsListValue : modifyFpgaImageAttributeRequestUserGroupsList) {
                if (modifyFpgaImageAttributeRequestUserGroupsListValue != null) {
                    request.addParameter("UserGroup." + userGroupsListIndex,
                            StringUtils.fromString(modifyFpgaImageAttributeRequestUserGroupsListValue));
                }
                userGroupsListIndex++;
            }
        }

        java.util.List<String> modifyFpgaImageAttributeRequestProductCodesList = modifyFpgaImageAttributeRequest.productCodes();
        if (modifyFpgaImageAttributeRequestProductCodesList != null) {
            int productCodesListIndex = 1;

            for (String modifyFpgaImageAttributeRequestProductCodesListValue : modifyFpgaImageAttributeRequestProductCodesList) {
                if (modifyFpgaImageAttributeRequestProductCodesListValue != null) {
                    request.addParameter("ProductCode." + productCodesListIndex,
                            StringUtils.fromString(modifyFpgaImageAttributeRequestProductCodesListValue));
                }
                productCodesListIndex++;
            }
        }

        LoadPermissionModifications loadPermission = modifyFpgaImageAttributeRequest.loadPermission();
        if (loadPermission != null) {

            java.util.List<LoadPermissionRequest> loadPermissionModificationsAddList = loadPermission.add();
            if (loadPermissionModificationsAddList != null) {
                int addListIndex = 1;

                for (LoadPermissionRequest loadPermissionModificationsAddListValue : loadPermissionModificationsAddList) {

                    if (loadPermissionModificationsAddListValue.groupAsString() != null) {
                        request.addParameter("LoadPermission.Add." + addListIndex + ".Group",
                                StringUtils.fromString(loadPermissionModificationsAddListValue.groupAsString()));
                    }

                    if (loadPermissionModificationsAddListValue.userId() != null) {
                        request.addParameter("LoadPermission.Add." + addListIndex + ".UserId",
                                StringUtils.fromString(loadPermissionModificationsAddListValue.userId()));
                    }
                    addListIndex++;
                }
            }

            java.util.List<LoadPermissionRequest> loadPermissionModificationsRemoveList = loadPermission.remove();
            if (loadPermissionModificationsRemoveList != null) {
                int removeListIndex = 1;

                for (LoadPermissionRequest loadPermissionModificationsRemoveListValue : loadPermissionModificationsRemoveList) {

                    if (loadPermissionModificationsRemoveListValue.groupAsString() != null) {
                        request.addParameter("LoadPermission.Remove." + removeListIndex + ".Group",
                                StringUtils.fromString(loadPermissionModificationsRemoveListValue.groupAsString()));
                    }

                    if (loadPermissionModificationsRemoveListValue.userId() != null) {
                        request.addParameter("LoadPermission.Remove." + removeListIndex + ".UserId",
                                StringUtils.fromString(loadPermissionModificationsRemoveListValue.userId()));
                    }
                    removeListIndex++;
                }
            }
        }

        if (modifyFpgaImageAttributeRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString(modifyFpgaImageAttributeRequest.description()));
        }

        if (modifyFpgaImageAttributeRequest.name() != null) {
            request.addParameter("Name", StringUtils.fromString(modifyFpgaImageAttributeRequest.name()));
        }

        return request;
    }

}
