/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * LaunchPermissionModifications StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class LaunchPermissionModificationsUnmarshaller implements
        Unmarshaller<LaunchPermissionModifications, StaxUnmarshallerContext> {

    public LaunchPermissionModifications unmarshall(StaxUnmarshallerContext context) throws Exception {
        LaunchPermissionModifications.Builder launchPermissionModifications = LaunchPermissionModifications.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<LaunchPermission> add = null;
        java.util.List<LaunchPermission> remove = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                launchPermissionModifications.add(add);
                launchPermissionModifications.remove(remove);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Add", targetDepth)) {
                    add = new ArrayList<LaunchPermission>();
                    continue;
                }

                if (context.testExpression("Add/item", targetDepth)) {
                    add.add(LaunchPermissionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Remove", targetDepth)) {
                    remove = new ArrayList<LaunchPermission>();
                    continue;
                }

                if (context.testExpression("Remove/item", targetDepth)) {
                    remove.add(LaunchPermissionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    launchPermissionModifications.add(add);
                    launchPermissionModifications.remove(remove);
                    break;
                }
            }
        }
        return launchPermissionModifications.build();
    }

    private static final LaunchPermissionModificationsUnmarshaller INSTANCE = new LaunchPermissionModificationsUnmarshaller();

    public static LaunchPermissionModificationsUnmarshaller getInstance() {
        return INSTANCE;
    }
}
