/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * ImportInstanceTaskDetails StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ImportInstanceTaskDetailsUnmarshaller implements Unmarshaller<ImportInstanceTaskDetails, StaxUnmarshallerContext> {

    public ImportInstanceTaskDetails unmarshall(StaxUnmarshallerContext context) throws Exception {
        ImportInstanceTaskDetails.Builder importInstanceTaskDetails = ImportInstanceTaskDetails.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<ImportInstanceVolumeDetailItem> volumes = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                importInstanceTaskDetails.volumes(volumes);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("description", targetDepth)) {
                    importInstanceTaskDetails.description(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("instanceId", targetDepth)) {
                    importInstanceTaskDetails.instanceId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("platform", targetDepth)) {
                    importInstanceTaskDetails.platform(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("volumes", targetDepth)) {
                    volumes = new ArrayList<ImportInstanceVolumeDetailItem>();
                    continue;
                }

                if (context.testExpression("volumes/item", targetDepth)) {
                    volumes.add(ImportInstanceVolumeDetailItemUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    importInstanceTaskDetails.volumes(volumes);
                    break;
                }
            }
        }
        return importInstanceTaskDetails.build();
    }

    private static final ImportInstanceTaskDetailsUnmarshaller INSTANCE = new ImportInstanceTaskDetailsUnmarshaller();

    public static ImportInstanceTaskDetailsUnmarshaller getInstance() {
        return INSTANCE;
    }
}
