/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * DhcpConfiguration StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DhcpConfigurationUnmarshaller implements Unmarshaller<DhcpConfiguration, StaxUnmarshallerContext> {

    public DhcpConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        DhcpConfiguration.Builder dhcpConfiguration = DhcpConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<String> values = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                dhcpConfiguration.values(values);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("key", targetDepth)) {
                    dhcpConfiguration.key(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("valueSet", targetDepth)) {
                    values = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("valueSet/item/value", targetDepth)) {
                    values.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    dhcpConfiguration.values(values);
                    break;
                }
            }
        }
        return dhcpConfiguration.build();
    }

    private static final DhcpConfigurationUnmarshaller INSTANCE = new DhcpConfigurationUnmarshaller();

    public static DhcpConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}
