/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * DescribeVpcEndpointServicesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeVpcEndpointServicesRequestMarshaller implements
        Marshaller<Request<DescribeVpcEndpointServicesRequest>, DescribeVpcEndpointServicesRequest> {

    public Request<DescribeVpcEndpointServicesRequest> marshall(
            DescribeVpcEndpointServicesRequest describeVpcEndpointServicesRequest) {

        if (describeVpcEndpointServicesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeVpcEndpointServicesRequest> request = new DefaultRequest<DescribeVpcEndpointServicesRequest>(
                describeVpcEndpointServicesRequest, "EC2Client");
        request.addParameter("Action", "DescribeVpcEndpointServices");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<String> describeVpcEndpointServicesRequestServiceNamesList = describeVpcEndpointServicesRequest
                .serviceNames();
        if (describeVpcEndpointServicesRequestServiceNamesList != null) {
            int serviceNamesListIndex = 1;

            for (String describeVpcEndpointServicesRequestServiceNamesListValue : describeVpcEndpointServicesRequestServiceNamesList) {
                if (describeVpcEndpointServicesRequestServiceNamesListValue != null) {
                    request.addParameter("ServiceName." + serviceNamesListIndex,
                            StringUtils.fromString(describeVpcEndpointServicesRequestServiceNamesListValue));
                }
                serviceNamesListIndex++;
            }
        }

        java.util.List<Filter> describeVpcEndpointServicesRequestFiltersList = describeVpcEndpointServicesRequest.filters();
        if (describeVpcEndpointServicesRequestFiltersList != null) {
            int filtersListIndex = 1;

            for (Filter describeVpcEndpointServicesRequestFiltersListValue : describeVpcEndpointServicesRequestFiltersList) {

                if (describeVpcEndpointServicesRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name",
                            StringUtils.fromString(describeVpcEndpointServicesRequestFiltersListValue.name()));
                }

                java.util.List<String> filterValuesList = describeVpcEndpointServicesRequestFiltersListValue.values();
                if (filterValuesList != null) {
                    int valuesListIndex = 1;

                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex,
                                    StringUtils.fromString(filterValuesListValue));
                        }
                        valuesListIndex++;
                    }
                }
                filtersListIndex++;
            }
        }

        if (describeVpcEndpointServicesRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeVpcEndpointServicesRequest.maxResults()));
        }

        if (describeVpcEndpointServicesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeVpcEndpointServicesRequest.nextToken()));
        }

        return request;
    }

}
