/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * DescribeVolumeStatusResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeVolumeStatusResponseUnmarshaller implements
        Unmarshaller<DescribeVolumeStatusResponse, StaxUnmarshallerContext> {

    public DescribeVolumeStatusResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribeVolumeStatusResponse.Builder describeVolumeStatusResponse = DescribeVolumeStatusResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<VolumeStatusItem> volumeStatuses = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                describeVolumeStatusResponse.volumeStatuses(volumeStatuses);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("nextToken", targetDepth)) {
                    describeVolumeStatusResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("volumeStatusSet", targetDepth)) {
                    volumeStatuses = new ArrayList<VolumeStatusItem>();
                    continue;
                }

                if (context.testExpression("volumeStatusSet/item", targetDepth)) {
                    volumeStatuses.add(VolumeStatusItemUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    describeVolumeStatusResponse.volumeStatuses(volumeStatuses);
                    break;
                }
            }
        }
        return describeVolumeStatusResponse.build();
    }

    private static final DescribeVolumeStatusResponseUnmarshaller INSTANCE = new DescribeVolumeStatusResponseUnmarshaller();

    public static DescribeVolumeStatusResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
