/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * DescribeSpotFleetRequestHistoryRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeSpotFleetRequestHistoryRequestMarshaller implements
        Marshaller<Request<DescribeSpotFleetRequestHistoryRequest>, DescribeSpotFleetRequestHistoryRequest> {

    public Request<DescribeSpotFleetRequestHistoryRequest> marshall(
            DescribeSpotFleetRequestHistoryRequest describeSpotFleetRequestHistoryRequest) {

        if (describeSpotFleetRequestHistoryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeSpotFleetRequestHistoryRequest> request = new DefaultRequest<DescribeSpotFleetRequestHistoryRequest>(
                describeSpotFleetRequestHistoryRequest, "EC2Client");
        request.addParameter("Action", "DescribeSpotFleetRequestHistory");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (describeSpotFleetRequestHistoryRequest.eventTypeAsString() != null) {
            request.addParameter("EventType", StringUtils.fromString(describeSpotFleetRequestHistoryRequest.eventTypeAsString()));
        }

        if (describeSpotFleetRequestHistoryRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeSpotFleetRequestHistoryRequest.maxResults()));
        }

        if (describeSpotFleetRequestHistoryRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeSpotFleetRequestHistoryRequest.nextToken()));
        }

        if (describeSpotFleetRequestHistoryRequest.spotFleetRequestId() != null) {
            request.addParameter("SpotFleetRequestId",
                    StringUtils.fromString(describeSpotFleetRequestHistoryRequest.spotFleetRequestId()));
        }

        if (describeSpotFleetRequestHistoryRequest.startTime() != null) {
            request.addParameter("StartTime", StringUtils.fromInstant(describeSpotFleetRequestHistoryRequest.startTime()));
        }

        return request;
    }

}
