/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * DescribeNetworkInterfacePermissionsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeNetworkInterfacePermissionsResponseUnmarshaller implements
        Unmarshaller<DescribeNetworkInterfacePermissionsResponse, StaxUnmarshallerContext> {

    public DescribeNetworkInterfacePermissionsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribeNetworkInterfacePermissionsResponse.Builder describeNetworkInterfacePermissionsResponse = DescribeNetworkInterfacePermissionsResponse
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<NetworkInterfacePermission> networkInterfacePermissions = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                describeNetworkInterfacePermissionsResponse.networkInterfacePermissions(networkInterfacePermissions);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("networkInterfacePermissions", targetDepth)) {
                    networkInterfacePermissions = new ArrayList<NetworkInterfacePermission>();
                    continue;
                }

                if (context.testExpression("networkInterfacePermissions/item", targetDepth)) {
                    networkInterfacePermissions.add(NetworkInterfacePermissionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("nextToken", targetDepth)) {
                    describeNetworkInterfacePermissionsResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    describeNetworkInterfacePermissionsResponse.networkInterfacePermissions(networkInterfacePermissions);
                    break;
                }
            }
        }
        return describeNetworkInterfacePermissionsResponse.build();
    }

    private static final DescribeNetworkInterfacePermissionsResponseUnmarshaller INSTANCE = new DescribeNetworkInterfacePermissionsResponseUnmarshaller();

    public static DescribeNetworkInterfacePermissionsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
