/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * CreateVolumeRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateVolumeRequestMarshaller implements Marshaller<Request<CreateVolumeRequest>, CreateVolumeRequest> {

    public Request<CreateVolumeRequest> marshall(CreateVolumeRequest createVolumeRequest) {

        if (createVolumeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<CreateVolumeRequest> request = new DefaultRequest<CreateVolumeRequest>(createVolumeRequest, "EC2Client");
        request.addParameter("Action", "CreateVolume");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (createVolumeRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString(createVolumeRequest.availabilityZone()));
        }

        if (createVolumeRequest.encrypted() != null) {
            request.addParameter("Encrypted", StringUtils.fromBoolean(createVolumeRequest.encrypted()));
        }

        if (createVolumeRequest.iops() != null) {
            request.addParameter("Iops", StringUtils.fromInteger(createVolumeRequest.iops()));
        }

        if (createVolumeRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString(createVolumeRequest.kmsKeyId()));
        }

        if (createVolumeRequest.size() != null) {
            request.addParameter("Size", StringUtils.fromInteger(createVolumeRequest.size()));
        }

        if (createVolumeRequest.snapshotId() != null) {
            request.addParameter("SnapshotId", StringUtils.fromString(createVolumeRequest.snapshotId()));
        }

        if (createVolumeRequest.volumeTypeAsString() != null) {
            request.addParameter("VolumeType", StringUtils.fromString(createVolumeRequest.volumeTypeAsString()));
        }

        java.util.List<TagSpecification> createVolumeRequestTagSpecificationsList = createVolumeRequest.tagSpecifications();
        if (createVolumeRequestTagSpecificationsList != null) {
            int tagSpecificationsListIndex = 1;

            for (TagSpecification createVolumeRequestTagSpecificationsListValue : createVolumeRequestTagSpecificationsList) {

                if (createVolumeRequestTagSpecificationsListValue.resourceTypeAsString() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType",
                            StringUtils.fromString(createVolumeRequestTagSpecificationsListValue.resourceTypeAsString()));
                }

                java.util.List<Tag> tagSpecificationTagsList = createVolumeRequestTagSpecificationsListValue.tags();
                if (tagSpecificationTagsList != null) {
                    int tagsListIndex = 1;

                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {

                        if (tagSpecificationTagsListValue.key() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex
                                    + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.key()));
                        }

                        if (tagSpecificationTagsListValue.value() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex
                                    + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.value()));
                        }
                        tagsListIndex++;
                    }
                }
                tagSpecificationsListIndex++;
            }
        }

        return request;
    }

}
