/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * CreateNetworkAclEntryRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateNetworkAclEntryRequestMarshaller implements
        Marshaller<Request<CreateNetworkAclEntryRequest>, CreateNetworkAclEntryRequest> {

    public Request<CreateNetworkAclEntryRequest> marshall(CreateNetworkAclEntryRequest createNetworkAclEntryRequest) {

        if (createNetworkAclEntryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<CreateNetworkAclEntryRequest> request = new DefaultRequest<CreateNetworkAclEntryRequest>(
                createNetworkAclEntryRequest, "EC2Client");
        request.addParameter("Action", "CreateNetworkAclEntry");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (createNetworkAclEntryRequest.cidrBlock() != null) {
            request.addParameter("CidrBlock", StringUtils.fromString(createNetworkAclEntryRequest.cidrBlock()));
        }

        if (createNetworkAclEntryRequest.egress() != null) {
            request.addParameter("Egress", StringUtils.fromBoolean(createNetworkAclEntryRequest.egress()));
        }

        IcmpTypeCode icmpTypeCode = createNetworkAclEntryRequest.icmpTypeCode();
        if (icmpTypeCode != null) {

            if (icmpTypeCode.code() != null) {
                request.addParameter("Icmp.Code", StringUtils.fromInteger(icmpTypeCode.code()));
            }

            if (icmpTypeCode.type() != null) {
                request.addParameter("Icmp.Type", StringUtils.fromInteger(icmpTypeCode.type()));
            }
        }

        if (createNetworkAclEntryRequest.ipv6CidrBlock() != null) {
            request.addParameter("Ipv6CidrBlock", StringUtils.fromString(createNetworkAclEntryRequest.ipv6CidrBlock()));
        }

        if (createNetworkAclEntryRequest.networkAclId() != null) {
            request.addParameter("NetworkAclId", StringUtils.fromString(createNetworkAclEntryRequest.networkAclId()));
        }

        PortRange portRange = createNetworkAclEntryRequest.portRange();
        if (portRange != null) {

            if (portRange.from() != null) {
                request.addParameter("PortRange.From", StringUtils.fromInteger(portRange.from()));
            }

            if (portRange.to() != null) {
                request.addParameter("PortRange.To", StringUtils.fromInteger(portRange.to()));
            }
        }

        if (createNetworkAclEntryRequest.protocol() != null) {
            request.addParameter("Protocol", StringUtils.fromString(createNetworkAclEntryRequest.protocol()));
        }

        if (createNetworkAclEntryRequest.ruleActionAsString() != null) {
            request.addParameter("RuleAction", StringUtils.fromString(createNetworkAclEntryRequest.ruleActionAsString()));
        }

        if (createNetworkAclEntryRequest.ruleNumber() != null) {
            request.addParameter("RuleNumber", StringUtils.fromInteger(createNetworkAclEntryRequest.ruleNumber()));
        }

        return request;
    }

}
