/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The tunnel options for a VPN connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VpnTunnelOptionsSpecification implements
        ToCopyableBuilder<VpnTunnelOptionsSpecification.Builder, VpnTunnelOptionsSpecification> {
    private final String tunnelInsideCidr;

    private final String preSharedKey;

    private VpnTunnelOptionsSpecification(BuilderImpl builder) {
        this.tunnelInsideCidr = builder.tunnelInsideCidr;
        this.preSharedKey = builder.preSharedKey;
    }

    /**
     * <p>
     * The range of inside IP addresses for the tunnel. Any specified CIDR blocks must be unique across all VPN
     * connections that use the same virtual private gateway.
     * </p>
     * <p>
     * Constraints: A size /30 CIDR block from the <code>169.254.0.0/16</code> range. The following CIDR blocks are
     * reserved and cannot be used:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>169.254.0.0/30</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>169.254.1.0/30</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>169.254.2.0/30</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>169.254.3.0/30</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>169.254.4.0/30</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>169.254.5.0/30</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>169.254.169.252/30</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The range of inside IP addresses for the tunnel. Any specified CIDR blocks must be unique across all VPN
     *         connections that use the same virtual private gateway. </p>
     *         <p>
     *         Constraints: A size /30 CIDR block from the <code>169.254.0.0/16</code> range. The following CIDR blocks
     *         are reserved and cannot be used:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>169.254.0.0/30</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>169.254.1.0/30</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>169.254.2.0/30</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>169.254.3.0/30</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>169.254.4.0/30</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>169.254.5.0/30</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>169.254.169.252/30</code>
     *         </p>
     *         </li>
     */
    public String tunnelInsideCidr() {
        return tunnelInsideCidr;
    }

    /**
     * <p>
     * The pre-shared key (PSK) to establish initial authentication between the virtual private gateway and customer
     * gateway.
     * </p>
     * <p>
     * Constraints: Allowed characters are alphanumeric characters and ._. Must be between 8 and 64 characters in length
     * and cannot start with zero (0).
     * </p>
     * 
     * @return The pre-shared key (PSK) to establish initial authentication between the virtual private gateway and
     *         customer gateway.</p>
     *         <p>
     *         Constraints: Allowed characters are alphanumeric characters and ._. Must be between 8 and 64 characters
     *         in length and cannot start with zero (0).
     */
    public String preSharedKey() {
        return preSharedKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tunnelInsideCidr());
        hashCode = 31 * hashCode + Objects.hashCode(preSharedKey());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpnTunnelOptionsSpecification)) {
            return false;
        }
        VpnTunnelOptionsSpecification other = (VpnTunnelOptionsSpecification) obj;
        return Objects.equals(tunnelInsideCidr(), other.tunnelInsideCidr())
                && Objects.equals(preSharedKey(), other.preSharedKey());
    }

    @Override
    public String toString() {
        return ToString.builder("VpnTunnelOptionsSpecification").add("TunnelInsideCidr", tunnelInsideCidr())
                .add("PreSharedKey", preSharedKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TunnelInsideCidr":
            return Optional.of(clazz.cast(tunnelInsideCidr()));
        case "PreSharedKey":
            return Optional.of(clazz.cast(preSharedKey()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, VpnTunnelOptionsSpecification> {
        /**
         * <p>
         * The range of inside IP addresses for the tunnel. Any specified CIDR blocks must be unique across all VPN
         * connections that use the same virtual private gateway.
         * </p>
         * <p>
         * Constraints: A size /30 CIDR block from the <code>169.254.0.0/16</code> range. The following CIDR blocks are
         * reserved and cannot be used:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>169.254.0.0/30</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>169.254.1.0/30</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>169.254.2.0/30</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>169.254.3.0/30</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>169.254.4.0/30</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>169.254.5.0/30</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>169.254.169.252/30</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param tunnelInsideCidr
         *        The range of inside IP addresses for the tunnel. Any specified CIDR blocks must be unique across all
         *        VPN connections that use the same virtual private gateway. </p>
         *        <p>
         *        Constraints: A size /30 CIDR block from the <code>169.254.0.0/16</code> range. The following CIDR
         *        blocks are reserved and cannot be used:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>169.254.0.0/30</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>169.254.1.0/30</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>169.254.2.0/30</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>169.254.3.0/30</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>169.254.4.0/30</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>169.254.5.0/30</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>169.254.169.252/30</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnelInsideCidr(String tunnelInsideCidr);

        /**
         * <p>
         * The pre-shared key (PSK) to establish initial authentication between the virtual private gateway and customer
         * gateway.
         * </p>
         * <p>
         * Constraints: Allowed characters are alphanumeric characters and ._. Must be between 8 and 64 characters in
         * length and cannot start with zero (0).
         * </p>
         * 
         * @param preSharedKey
         *        The pre-shared key (PSK) to establish initial authentication between the virtual private gateway and
         *        customer gateway.</p>
         *        <p>
         *        Constraints: Allowed characters are alphanumeric characters and ._. Must be between 8 and 64
         *        characters in length and cannot start with zero (0).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preSharedKey(String preSharedKey);
    }

    static final class BuilderImpl implements Builder {
        private String tunnelInsideCidr;

        private String preSharedKey;

        private BuilderImpl() {
        }

        private BuilderImpl(VpnTunnelOptionsSpecification model) {
            tunnelInsideCidr(model.tunnelInsideCidr);
            preSharedKey(model.preSharedKey);
        }

        public final String getTunnelInsideCidr() {
            return tunnelInsideCidr;
        }

        @Override
        public final Builder tunnelInsideCidr(String tunnelInsideCidr) {
            this.tunnelInsideCidr = tunnelInsideCidr;
            return this;
        }

        public final void setTunnelInsideCidr(String tunnelInsideCidr) {
            this.tunnelInsideCidr = tunnelInsideCidr;
        }

        public final String getPreSharedKey() {
            return preSharedKey;
        }

        @Override
        public final Builder preSharedKey(String preSharedKey) {
            this.preSharedKey = preSharedKey;
            return this;
        }

        public final void setPreSharedKey(String preSharedKey) {
            this.preSharedKey = preSharedKey;
        }

        @Override
        public VpnTunnelOptionsSpecification build() {
            return new VpnTunnelOptionsSpecification(this);
        }
    }
}
