/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the VPC peering connection options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VpcPeeringConnectionOptionsDescription implements
        ToCopyableBuilder<VpcPeeringConnectionOptionsDescription.Builder, VpcPeeringConnectionOptionsDescription> {
    private final Boolean allowDnsResolutionFromRemoteVpc;

    private final Boolean allowEgressFromLocalClassicLinkToRemoteVpc;

    private final Boolean allowEgressFromLocalVpcToRemoteClassicLink;

    private VpcPeeringConnectionOptionsDescription(BuilderImpl builder) {
        this.allowDnsResolutionFromRemoteVpc = builder.allowDnsResolutionFromRemoteVpc;
        this.allowEgressFromLocalClassicLinkToRemoteVpc = builder.allowEgressFromLocalClassicLinkToRemoteVpc;
        this.allowEgressFromLocalVpcToRemoteClassicLink = builder.allowEgressFromLocalVpcToRemoteClassicLink;
    }

    /**
     * <p>
     * Indicates whether a local VPC can resolve public DNS hostnames to private IP addresses when queried from
     * instances in a peer VPC.
     * </p>
     * 
     * @return Indicates whether a local VPC can resolve public DNS hostnames to private IP addresses when queried from
     *         instances in a peer VPC.
     */
    public Boolean allowDnsResolutionFromRemoteVpc() {
        return allowDnsResolutionFromRemoteVpc;
    }

    /**
     * <p>
     * Indicates whether a local ClassicLink connection can communicate with the peer VPC over the VPC peering
     * connection.
     * </p>
     * 
     * @return Indicates whether a local ClassicLink connection can communicate with the peer VPC over the VPC peering
     *         connection.
     */
    public Boolean allowEgressFromLocalClassicLinkToRemoteVpc() {
        return allowEgressFromLocalClassicLinkToRemoteVpc;
    }

    /**
     * <p>
     * Indicates whether a local VPC can communicate with a ClassicLink connection in the peer VPC over the VPC peering
     * connection.
     * </p>
     * 
     * @return Indicates whether a local VPC can communicate with a ClassicLink connection in the peer VPC over the VPC
     *         peering connection.
     */
    public Boolean allowEgressFromLocalVpcToRemoteClassicLink() {
        return allowEgressFromLocalVpcToRemoteClassicLink;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowDnsResolutionFromRemoteVpc());
        hashCode = 31 * hashCode + Objects.hashCode(allowEgressFromLocalClassicLinkToRemoteVpc());
        hashCode = 31 * hashCode + Objects.hashCode(allowEgressFromLocalVpcToRemoteClassicLink());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcPeeringConnectionOptionsDescription)) {
            return false;
        }
        VpcPeeringConnectionOptionsDescription other = (VpcPeeringConnectionOptionsDescription) obj;
        return Objects.equals(allowDnsResolutionFromRemoteVpc(), other.allowDnsResolutionFromRemoteVpc())
                && Objects.equals(allowEgressFromLocalClassicLinkToRemoteVpc(),
                        other.allowEgressFromLocalClassicLinkToRemoteVpc())
                && Objects.equals(allowEgressFromLocalVpcToRemoteClassicLink(),
                        other.allowEgressFromLocalVpcToRemoteClassicLink());
    }

    @Override
    public String toString() {
        return ToString.builder("VpcPeeringConnectionOptionsDescription")
                .add("AllowDnsResolutionFromRemoteVpc", allowDnsResolutionFromRemoteVpc())
                .add("AllowEgressFromLocalClassicLinkToRemoteVpc", allowEgressFromLocalClassicLinkToRemoteVpc())
                .add("AllowEgressFromLocalVpcToRemoteClassicLink", allowEgressFromLocalVpcToRemoteClassicLink()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowDnsResolutionFromRemoteVpc":
            return Optional.of(clazz.cast(allowDnsResolutionFromRemoteVpc()));
        case "AllowEgressFromLocalClassicLinkToRemoteVpc":
            return Optional.of(clazz.cast(allowEgressFromLocalClassicLinkToRemoteVpc()));
        case "AllowEgressFromLocalVpcToRemoteClassicLink":
            return Optional.of(clazz.cast(allowEgressFromLocalVpcToRemoteClassicLink()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, VpcPeeringConnectionOptionsDescription> {
        /**
         * <p>
         * Indicates whether a local VPC can resolve public DNS hostnames to private IP addresses when queried from
         * instances in a peer VPC.
         * </p>
         * 
         * @param allowDnsResolutionFromRemoteVpc
         *        Indicates whether a local VPC can resolve public DNS hostnames to private IP addresses when queried
         *        from instances in a peer VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowDnsResolutionFromRemoteVpc(Boolean allowDnsResolutionFromRemoteVpc);

        /**
         * <p>
         * Indicates whether a local ClassicLink connection can communicate with the peer VPC over the VPC peering
         * connection.
         * </p>
         * 
         * @param allowEgressFromLocalClassicLinkToRemoteVpc
         *        Indicates whether a local ClassicLink connection can communicate with the peer VPC over the VPC
         *        peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowEgressFromLocalClassicLinkToRemoteVpc(Boolean allowEgressFromLocalClassicLinkToRemoteVpc);

        /**
         * <p>
         * Indicates whether a local VPC can communicate with a ClassicLink connection in the peer VPC over the VPC
         * peering connection.
         * </p>
         * 
         * @param allowEgressFromLocalVpcToRemoteClassicLink
         *        Indicates whether a local VPC can communicate with a ClassicLink connection in the peer VPC over the
         *        VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowEgressFromLocalVpcToRemoteClassicLink(Boolean allowEgressFromLocalVpcToRemoteClassicLink);
    }

    static final class BuilderImpl implements Builder {
        private Boolean allowDnsResolutionFromRemoteVpc;

        private Boolean allowEgressFromLocalClassicLinkToRemoteVpc;

        private Boolean allowEgressFromLocalVpcToRemoteClassicLink;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcPeeringConnectionOptionsDescription model) {
            allowDnsResolutionFromRemoteVpc(model.allowDnsResolutionFromRemoteVpc);
            allowEgressFromLocalClassicLinkToRemoteVpc(model.allowEgressFromLocalClassicLinkToRemoteVpc);
            allowEgressFromLocalVpcToRemoteClassicLink(model.allowEgressFromLocalVpcToRemoteClassicLink);
        }

        public final Boolean getAllowDnsResolutionFromRemoteVpc() {
            return allowDnsResolutionFromRemoteVpc;
        }

        @Override
        public final Builder allowDnsResolutionFromRemoteVpc(Boolean allowDnsResolutionFromRemoteVpc) {
            this.allowDnsResolutionFromRemoteVpc = allowDnsResolutionFromRemoteVpc;
            return this;
        }

        public final void setAllowDnsResolutionFromRemoteVpc(Boolean allowDnsResolutionFromRemoteVpc) {
            this.allowDnsResolutionFromRemoteVpc = allowDnsResolutionFromRemoteVpc;
        }

        public final Boolean getAllowEgressFromLocalClassicLinkToRemoteVpc() {
            return allowEgressFromLocalClassicLinkToRemoteVpc;
        }

        @Override
        public final Builder allowEgressFromLocalClassicLinkToRemoteVpc(Boolean allowEgressFromLocalClassicLinkToRemoteVpc) {
            this.allowEgressFromLocalClassicLinkToRemoteVpc = allowEgressFromLocalClassicLinkToRemoteVpc;
            return this;
        }

        public final void setAllowEgressFromLocalClassicLinkToRemoteVpc(Boolean allowEgressFromLocalClassicLinkToRemoteVpc) {
            this.allowEgressFromLocalClassicLinkToRemoteVpc = allowEgressFromLocalClassicLinkToRemoteVpc;
        }

        public final Boolean getAllowEgressFromLocalVpcToRemoteClassicLink() {
            return allowEgressFromLocalVpcToRemoteClassicLink;
        }

        @Override
        public final Builder allowEgressFromLocalVpcToRemoteClassicLink(Boolean allowEgressFromLocalVpcToRemoteClassicLink) {
            this.allowEgressFromLocalVpcToRemoteClassicLink = allowEgressFromLocalVpcToRemoteClassicLink;
            return this;
        }

        public final void setAllowEgressFromLocalVpcToRemoteClassicLink(Boolean allowEgressFromLocalVpcToRemoteClassicLink) {
            this.allowEgressFromLocalVpcToRemoteClassicLink = allowEgressFromLocalVpcToRemoteClassicLink;
        }

        @Override
        public VpcPeeringConnectionOptionsDescription build() {
            return new VpcPeeringConnectionOptionsDescription(this);
        }
    }
}
