/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UnassignIpv6AddressesRequest extends EC2Request implements
        ToCopyableBuilder<UnassignIpv6AddressesRequest.Builder, UnassignIpv6AddressesRequest> {
    private final List<String> ipv6Addresses;

    private final String networkInterfaceId;

    private UnassignIpv6AddressesRequest(BuilderImpl builder) {
        super(builder);
        this.ipv6Addresses = builder.ipv6Addresses;
        this.networkInterfaceId = builder.networkInterfaceId;
    }

    /**
     * <p>
     * The IPv6 addresses to unassign from the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IPv6 addresses to unassign from the network interface.
     */
    public List<String> ipv6Addresses() {
        return ipv6Addresses;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipv6Addresses());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnassignIpv6AddressesRequest)) {
            return false;
        }
        UnassignIpv6AddressesRequest other = (UnassignIpv6AddressesRequest) obj;
        return Objects.equals(ipv6Addresses(), other.ipv6Addresses())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId());
    }

    @Override
    public String toString() {
        return ToString.builder("UnassignIpv6AddressesRequest").add("Ipv6Addresses", ipv6Addresses())
                .add("NetworkInterfaceId", networkInterfaceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ipv6Addresses":
            return Optional.of(clazz.cast(ipv6Addresses()));
        case "NetworkInterfaceId":
            return Optional.of(clazz.cast(networkInterfaceId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, UnassignIpv6AddressesRequest> {
        /**
         * <p>
         * The IPv6 addresses to unassign from the network interface.
         * </p>
         * 
         * @param ipv6Addresses
         *        The IPv6 addresses to unassign from the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(Collection<String> ipv6Addresses);

        /**
         * <p>
         * The IPv6 addresses to unassign from the network interface.
         * </p>
         * 
         * @param ipv6Addresses
         *        The IPv6 addresses to unassign from the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(String... ipv6Addresses);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private List<String> ipv6Addresses;

        private String networkInterfaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(UnassignIpv6AddressesRequest model) {
            super(model);
            ipv6Addresses(model.ipv6Addresses);
            networkInterfaceId(model.networkInterfaceId);
        }

        public final Collection<String> getIpv6Addresses() {
            return ipv6Addresses;
        }

        @Override
        public final Builder ipv6Addresses(Collection<String> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(String... ipv6Addresses) {
            ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        public final void setIpv6Addresses(Collection<String> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressListCopier.copy(ipv6Addresses);
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UnassignIpv6AddressesRequest build() {
            return new UnassignIpv6AddressesRequest(this);
        }
    }
}
