/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of StartInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StartInstancesResponse extends EC2Response implements
        ToCopyableBuilder<StartInstancesResponse.Builder, StartInstancesResponse> {
    private final List<InstanceStateChange> startingInstances;

    private StartInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.startingInstances = builder.startingInstances;
    }

    /**
     * <p>
     * Information about one or more started instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more started instances.
     */
    public List<InstanceStateChange> startingInstances() {
        return startingInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startingInstances());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartInstancesResponse)) {
            return false;
        }
        StartInstancesResponse other = (StartInstancesResponse) obj;
        return Objects.equals(startingInstances(), other.startingInstances());
    }

    @Override
    public String toString() {
        return ToString.builder("StartInstancesResponse").add("StartingInstances", startingInstances()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartingInstances":
            return Optional.of(clazz.cast(startingInstances()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, StartInstancesResponse> {
        /**
         * <p>
         * Information about one or more started instances.
         * </p>
         * 
         * @param startingInstances
         *        Information about one or more started instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startingInstances(Collection<InstanceStateChange> startingInstances);

        /**
         * <p>
         * Information about one or more started instances.
         * </p>
         * 
         * @param startingInstances
         *        Information about one or more started instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startingInstances(InstanceStateChange... startingInstances);

        /**
         * <p>
         * Information about one or more started instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceStateChange>.Builder} avoiding the
         * need to create one manually via {@link List<InstanceStateChange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceStateChange>.Builder#build()} is called immediately
         * and its result is passed to {@link #startingInstances(List<InstanceStateChange>)}.
         * 
         * @param startingInstances
         *        a consumer that will call methods on {@link List<InstanceStateChange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startingInstances(List<InstanceStateChange>)
         */
        Builder startingInstances(Consumer<InstanceStateChange.Builder>... startingInstances);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<InstanceStateChange> startingInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(StartInstancesResponse model) {
            super(model);
            startingInstances(model.startingInstances);
        }

        public final Collection<InstanceStateChange.Builder> getStartingInstances() {
            return startingInstances != null ? startingInstances.stream().map(InstanceStateChange::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder startingInstances(Collection<InstanceStateChange> startingInstances) {
            this.startingInstances = InstanceStateChangeListCopier.copy(startingInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder startingInstances(InstanceStateChange... startingInstances) {
            startingInstances(Arrays.asList(startingInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder startingInstances(Consumer<InstanceStateChange.Builder>... startingInstances) {
            startingInstances(Stream.of(startingInstances).map(c -> InstanceStateChange.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStartingInstances(Collection<InstanceStateChange.BuilderImpl> startingInstances) {
            this.startingInstances = InstanceStateChangeListCopier.copyFromBuilder(startingInstances);
        }

        @Override
        public StartInstancesResponse build() {
            return new StartInstancesResponse(this);
        }
    }
}
