/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the recurring schedule for a Scheduled Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ScheduledInstanceRecurrenceRequest implements
        ToCopyableBuilder<ScheduledInstanceRecurrenceRequest.Builder, ScheduledInstanceRecurrenceRequest> {
    private final String frequency;

    private final Integer interval;

    private final List<Integer> occurrenceDays;

    private final Boolean occurrenceRelativeToEnd;

    private final String occurrenceUnit;

    private ScheduledInstanceRecurrenceRequest(BuilderImpl builder) {
        this.frequency = builder.frequency;
        this.interval = builder.interval;
        this.occurrenceDays = builder.occurrenceDays;
        this.occurrenceRelativeToEnd = builder.occurrenceRelativeToEnd;
        this.occurrenceUnit = builder.occurrenceUnit;
    }

    /**
     * <p>
     * The frequency (<code>Daily</code>, <code>Weekly</code>, or <code>Monthly</code>).
     * </p>
     * 
     * @return The frequency (<code>Daily</code>, <code>Weekly</code>, or <code>Monthly</code>).
     */
    public String frequency() {
        return frequency;
    }

    /**
     * <p>
     * The interval quantity. The interval unit depends on the value of <code>Frequency</code>. For example, every 2
     * weeks or every 2 months.
     * </p>
     * 
     * @return The interval quantity. The interval unit depends on the value of <code>Frequency</code>. For example,
     *         every 2 weeks or every 2 months.
     */
    public Integer interval() {
        return interval;
    }

    /**
     * <p>
     * The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule, this is
     * one or more days of the week (1-7, where 1 is Sunday). You can't specify this value with a daily schedule. If the
     * occurrence is relative to the end of the month, you can specify only a single day.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule,
     *         this is one or more days of the week (1-7, where 1 is Sunday). You can't specify this value with a daily
     *         schedule. If the occurrence is relative to the end of the month, you can specify only a single day.
     */
    public List<Integer> occurrenceDays() {
        return occurrenceDays;
    }

    /**
     * <p>
     * Indicates whether the occurrence is relative to the end of the specified week or month. You can't specify this
     * value with a daily schedule.
     * </p>
     * 
     * @return Indicates whether the occurrence is relative to the end of the specified week or month. You can't specify
     *         this value with a daily schedule.
     */
    public Boolean occurrenceRelativeToEnd() {
        return occurrenceRelativeToEnd;
    }

    /**
     * <p>
     * The unit for <code>OccurrenceDays</code> (<code>DayOfWeek</code> or <code>DayOfMonth</code>). This value is
     * required for a monthly schedule. You can't specify <code>DayOfWeek</code> with a weekly schedule. You can't
     * specify this value with a daily schedule.
     * </p>
     * 
     * @return The unit for <code>OccurrenceDays</code> (<code>DayOfWeek</code> or <code>DayOfMonth</code>). This value
     *         is required for a monthly schedule. You can't specify <code>DayOfWeek</code> with a weekly schedule. You
     *         can't specify this value with a daily schedule.
     */
    public String occurrenceUnit() {
        return occurrenceUnit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(frequency());
        hashCode = 31 * hashCode + Objects.hashCode(interval());
        hashCode = 31 * hashCode + Objects.hashCode(occurrenceDays());
        hashCode = 31 * hashCode + Objects.hashCode(occurrenceRelativeToEnd());
        hashCode = 31 * hashCode + Objects.hashCode(occurrenceUnit());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstanceRecurrenceRequest)) {
            return false;
        }
        ScheduledInstanceRecurrenceRequest other = (ScheduledInstanceRecurrenceRequest) obj;
        return Objects.equals(frequency(), other.frequency()) && Objects.equals(interval(), other.interval())
                && Objects.equals(occurrenceDays(), other.occurrenceDays())
                && Objects.equals(occurrenceRelativeToEnd(), other.occurrenceRelativeToEnd())
                && Objects.equals(occurrenceUnit(), other.occurrenceUnit());
    }

    @Override
    public String toString() {
        return ToString.builder("ScheduledInstanceRecurrenceRequest").add("Frequency", frequency()).add("Interval", interval())
                .add("OccurrenceDays", occurrenceDays()).add("OccurrenceRelativeToEnd", occurrenceRelativeToEnd())
                .add("OccurrenceUnit", occurrenceUnit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Frequency":
            return Optional.of(clazz.cast(frequency()));
        case "Interval":
            return Optional.of(clazz.cast(interval()));
        case "OccurrenceDays":
            return Optional.of(clazz.cast(occurrenceDays()));
        case "OccurrenceRelativeToEnd":
            return Optional.of(clazz.cast(occurrenceRelativeToEnd()));
        case "OccurrenceUnit":
            return Optional.of(clazz.cast(occurrenceUnit()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ScheduledInstanceRecurrenceRequest> {
        /**
         * <p>
         * The frequency (<code>Daily</code>, <code>Weekly</code>, or <code>Monthly</code>).
         * </p>
         * 
         * @param frequency
         *        The frequency (<code>Daily</code>, <code>Weekly</code>, or <code>Monthly</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frequency(String frequency);

        /**
         * <p>
         * The interval quantity. The interval unit depends on the value of <code>Frequency</code>. For example, every 2
         * weeks or every 2 months.
         * </p>
         * 
         * @param interval
         *        The interval quantity. The interval unit depends on the value of <code>Frequency</code>. For example,
         *        every 2 weeks or every 2 months.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interval(Integer interval);

        /**
         * <p>
         * The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule, this
         * is one or more days of the week (1-7, where 1 is Sunday). You can't specify this value with a daily schedule.
         * If the occurrence is relative to the end of the month, you can specify only a single day.
         * </p>
         * 
         * @param occurrenceDays
         *        The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule,
         *        this is one or more days of the week (1-7, where 1 is Sunday). You can't specify this value with a
         *        daily schedule. If the occurrence is relative to the end of the month, you can specify only a single
         *        day.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder occurrenceDays(Collection<Integer> occurrenceDays);

        /**
         * <p>
         * The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule, this
         * is one or more days of the week (1-7, where 1 is Sunday). You can't specify this value with a daily schedule.
         * If the occurrence is relative to the end of the month, you can specify only a single day.
         * </p>
         * 
         * @param occurrenceDays
         *        The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule,
         *        this is one or more days of the week (1-7, where 1 is Sunday). You can't specify this value with a
         *        daily schedule. If the occurrence is relative to the end of the month, you can specify only a single
         *        day.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder occurrenceDays(Integer... occurrenceDays);

        /**
         * <p>
         * Indicates whether the occurrence is relative to the end of the specified week or month. You can't specify
         * this value with a daily schedule.
         * </p>
         * 
         * @param occurrenceRelativeToEnd
         *        Indicates whether the occurrence is relative to the end of the specified week or month. You can't
         *        specify this value with a daily schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder occurrenceRelativeToEnd(Boolean occurrenceRelativeToEnd);

        /**
         * <p>
         * The unit for <code>OccurrenceDays</code> (<code>DayOfWeek</code> or <code>DayOfMonth</code>). This value is
         * required for a monthly schedule. You can't specify <code>DayOfWeek</code> with a weekly schedule. You can't
         * specify this value with a daily schedule.
         * </p>
         * 
         * @param occurrenceUnit
         *        The unit for <code>OccurrenceDays</code> (<code>DayOfWeek</code> or <code>DayOfMonth</code>). This
         *        value is required for a monthly schedule. You can't specify <code>DayOfWeek</code> with a weekly
         *        schedule. You can't specify this value with a daily schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder occurrenceUnit(String occurrenceUnit);
    }

    static final class BuilderImpl implements Builder {
        private String frequency;

        private Integer interval;

        private List<Integer> occurrenceDays;

        private Boolean occurrenceRelativeToEnd;

        private String occurrenceUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledInstanceRecurrenceRequest model) {
            frequency(model.frequency);
            interval(model.interval);
            occurrenceDays(model.occurrenceDays);
            occurrenceRelativeToEnd(model.occurrenceRelativeToEnd);
            occurrenceUnit(model.occurrenceUnit);
        }

        public final String getFrequency() {
            return frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        public final Integer getInterval() {
            return interval;
        }

        @Override
        public final Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public final void setInterval(Integer interval) {
            this.interval = interval;
        }

        public final Collection<Integer> getOccurrenceDays() {
            return occurrenceDays;
        }

        @Override
        public final Builder occurrenceDays(Collection<Integer> occurrenceDays) {
            this.occurrenceDays = OccurrenceDayRequestSetCopier.copy(occurrenceDays);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder occurrenceDays(Integer... occurrenceDays) {
            occurrenceDays(Arrays.asList(occurrenceDays));
            return this;
        }

        public final void setOccurrenceDays(Collection<Integer> occurrenceDays) {
            this.occurrenceDays = OccurrenceDayRequestSetCopier.copy(occurrenceDays);
        }

        public final Boolean getOccurrenceRelativeToEnd() {
            return occurrenceRelativeToEnd;
        }

        @Override
        public final Builder occurrenceRelativeToEnd(Boolean occurrenceRelativeToEnd) {
            this.occurrenceRelativeToEnd = occurrenceRelativeToEnd;
            return this;
        }

        public final void setOccurrenceRelativeToEnd(Boolean occurrenceRelativeToEnd) {
            this.occurrenceRelativeToEnd = occurrenceRelativeToEnd;
        }

        public final String getOccurrenceUnit() {
            return occurrenceUnit;
        }

        @Override
        public final Builder occurrenceUnit(String occurrenceUnit) {
            this.occurrenceUnit = occurrenceUnit;
            return this;
        }

        public final void setOccurrenceUnit(String occurrenceUnit) {
            this.occurrenceUnit = occurrenceUnit;
        }

        @Override
        public ScheduledInstanceRecurrenceRequest build() {
            return new ScheduledInstanceRecurrenceRequest(this);
        }
    }
}
