/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the modification request/s.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReservedInstancesModificationResult implements
        ToCopyableBuilder<ReservedInstancesModificationResult.Builder, ReservedInstancesModificationResult> {
    private final String reservedInstancesId;

    private final ReservedInstancesConfiguration targetConfiguration;

    private ReservedInstancesModificationResult(BuilderImpl builder) {
        this.reservedInstancesId = builder.reservedInstancesId;
        this.targetConfiguration = builder.targetConfiguration;
    }

    /**
     * <p>
     * The ID for the Reserved Instances that were created as part of the modification request. This field is only
     * available when the modification is fulfilled.
     * </p>
     * 
     * @return The ID for the Reserved Instances that were created as part of the modification request. This field is
     *         only available when the modification is fulfilled.
     */
    public String reservedInstancesId() {
        return reservedInstancesId;
    }

    /**
     * <p>
     * The target Reserved Instances configurations supplied as part of the modification request.
     * </p>
     * 
     * @return The target Reserved Instances configurations supplied as part of the modification request.
     */
    public ReservedInstancesConfiguration targetConfiguration() {
        return targetConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesId());
        hashCode = 31 * hashCode + Objects.hashCode(targetConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesModificationResult)) {
            return false;
        }
        ReservedInstancesModificationResult other = (ReservedInstancesModificationResult) obj;
        return Objects.equals(reservedInstancesId(), other.reservedInstancesId())
                && Objects.equals(targetConfiguration(), other.targetConfiguration());
    }

    @Override
    public String toString() {
        return ToString.builder("ReservedInstancesModificationResult").add("ReservedInstancesId", reservedInstancesId())
                .add("TargetConfiguration", targetConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedInstancesId":
            return Optional.of(clazz.cast(reservedInstancesId()));
        case "TargetConfiguration":
            return Optional.of(clazz.cast(targetConfiguration()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ReservedInstancesModificationResult> {
        /**
         * <p>
         * The ID for the Reserved Instances that were created as part of the modification request. This field is only
         * available when the modification is fulfilled.
         * </p>
         * 
         * @param reservedInstancesId
         *        The ID for the Reserved Instances that were created as part of the modification request. This field is
         *        only available when the modification is fulfilled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesId(String reservedInstancesId);

        /**
         * <p>
         * The target Reserved Instances configurations supplied as part of the modification request.
         * </p>
         * 
         * @param targetConfiguration
         *        The target Reserved Instances configurations supplied as part of the modification request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfiguration(ReservedInstancesConfiguration targetConfiguration);

        /**
         * <p>
         * The target Reserved Instances configurations supplied as part of the modification request.
         * </p>
         * This is a convenience that creates an instance of the {@link ReservedInstancesConfiguration.Builder} avoiding
         * the need to create one manually via {@link ReservedInstancesConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReservedInstancesConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #targetConfiguration(ReservedInstancesConfiguration)}.
         * 
         * @param targetConfiguration
         *        a consumer that will call methods on {@link ReservedInstancesConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetConfiguration(ReservedInstancesConfiguration)
         */
        default Builder targetConfiguration(Consumer<ReservedInstancesConfiguration.Builder> targetConfiguration) {
            return targetConfiguration(ReservedInstancesConfiguration.builder().apply(targetConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String reservedInstancesId;

        private ReservedInstancesConfiguration targetConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesModificationResult model) {
            reservedInstancesId(model.reservedInstancesId);
            targetConfiguration(model.targetConfiguration);
        }

        public final String getReservedInstancesId() {
            return reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        public final ReservedInstancesConfiguration.Builder getTargetConfiguration() {
            return targetConfiguration != null ? targetConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder targetConfiguration(ReservedInstancesConfiguration targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
            return this;
        }

        public final void setTargetConfiguration(ReservedInstancesConfiguration.BuilderImpl targetConfiguration) {
            this.targetConfiguration = targetConfiguration != null ? targetConfiguration.build() : null;
        }

        @Override
        public ReservedInstancesModificationResult build() {
            return new ReservedInstancesModificationResult(this);
        }
    }
}
