/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The cost associated with the Reserved Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReservationValue implements ToCopyableBuilder<ReservationValue.Builder, ReservationValue> {
    private final String hourlyPrice;

    private final String remainingTotalValue;

    private final String remainingUpfrontValue;

    private ReservationValue(BuilderImpl builder) {
        this.hourlyPrice = builder.hourlyPrice;
        this.remainingTotalValue = builder.remainingTotalValue;
        this.remainingUpfrontValue = builder.remainingUpfrontValue;
    }

    /**
     * <p>
     * The hourly rate of the reservation.
     * </p>
     * 
     * @return The hourly rate of the reservation.
     */
    public String hourlyPrice() {
        return hourlyPrice;
    }

    /**
     * <p>
     * The balance of the total value (the sum of remainingUpfrontValue + hourlyPrice * number of hours remaining).
     * </p>
     * 
     * @return The balance of the total value (the sum of remainingUpfrontValue + hourlyPrice * number of hours
     *         remaining).
     */
    public String remainingTotalValue() {
        return remainingTotalValue;
    }

    /**
     * <p>
     * The remaining upfront cost of the reservation.
     * </p>
     * 
     * @return The remaining upfront cost of the reservation.
     */
    public String remainingUpfrontValue() {
        return remainingUpfrontValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hourlyPrice());
        hashCode = 31 * hashCode + Objects.hashCode(remainingTotalValue());
        hashCode = 31 * hashCode + Objects.hashCode(remainingUpfrontValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservationValue)) {
            return false;
        }
        ReservationValue other = (ReservationValue) obj;
        return Objects.equals(hourlyPrice(), other.hourlyPrice())
                && Objects.equals(remainingTotalValue(), other.remainingTotalValue())
                && Objects.equals(remainingUpfrontValue(), other.remainingUpfrontValue());
    }

    @Override
    public String toString() {
        return ToString.builder("ReservationValue").add("HourlyPrice", hourlyPrice())
                .add("RemainingTotalValue", remainingTotalValue()).add("RemainingUpfrontValue", remainingUpfrontValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HourlyPrice":
            return Optional.of(clazz.cast(hourlyPrice()));
        case "RemainingTotalValue":
            return Optional.of(clazz.cast(remainingTotalValue()));
        case "RemainingUpfrontValue":
            return Optional.of(clazz.cast(remainingUpfrontValue()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ReservationValue> {
        /**
         * <p>
         * The hourly rate of the reservation.
         * </p>
         * 
         * @param hourlyPrice
         *        The hourly rate of the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hourlyPrice(String hourlyPrice);

        /**
         * <p>
         * The balance of the total value (the sum of remainingUpfrontValue + hourlyPrice * number of hours remaining).
         * </p>
         * 
         * @param remainingTotalValue
         *        The balance of the total value (the sum of remainingUpfrontValue + hourlyPrice * number of hours
         *        remaining).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remainingTotalValue(String remainingTotalValue);

        /**
         * <p>
         * The remaining upfront cost of the reservation.
         * </p>
         * 
         * @param remainingUpfrontValue
         *        The remaining upfront cost of the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remainingUpfrontValue(String remainingUpfrontValue);
    }

    static final class BuilderImpl implements Builder {
        private String hourlyPrice;

        private String remainingTotalValue;

        private String remainingUpfrontValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservationValue model) {
            hourlyPrice(model.hourlyPrice);
            remainingTotalValue(model.remainingTotalValue);
            remainingUpfrontValue(model.remainingUpfrontValue);
        }

        public final String getHourlyPrice() {
            return hourlyPrice;
        }

        @Override
        public final Builder hourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
            return this;
        }

        public final void setHourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
        }

        public final String getRemainingTotalValue() {
            return remainingTotalValue;
        }

        @Override
        public final Builder remainingTotalValue(String remainingTotalValue) {
            this.remainingTotalValue = remainingTotalValue;
            return this;
        }

        public final void setRemainingTotalValue(String remainingTotalValue) {
            this.remainingTotalValue = remainingTotalValue;
        }

        public final String getRemainingUpfrontValue() {
            return remainingUpfrontValue;
        }

        @Override
        public final Builder remainingUpfrontValue(String remainingUpfrontValue) {
            this.remainingUpfrontValue = remainingUpfrontValue;
            return this;
        }

        public final void setRemainingUpfrontValue(String remainingUpfrontValue) {
            this.remainingUpfrontValue = remainingUpfrontValue;
        }

        @Override
        public ReservationValue build() {
            return new ReservationValue(this);
        }
    }
}
