/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of ReplaceNetworkAclAssociation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReplaceNetworkAclAssociationResponse extends EC2Response implements
        ToCopyableBuilder<ReplaceNetworkAclAssociationResponse.Builder, ReplaceNetworkAclAssociationResponse> {
    private final String newAssociationId;

    private ReplaceNetworkAclAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.newAssociationId = builder.newAssociationId;
    }

    /**
     * <p>
     * The ID of the new association.
     * </p>
     * 
     * @return The ID of the new association.
     */
    public String newAssociationId() {
        return newAssociationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(newAssociationId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplaceNetworkAclAssociationResponse)) {
            return false;
        }
        ReplaceNetworkAclAssociationResponse other = (ReplaceNetworkAclAssociationResponse) obj;
        return Objects.equals(newAssociationId(), other.newAssociationId());
    }

    @Override
    public String toString() {
        return ToString.builder("ReplaceNetworkAclAssociationResponse").add("NewAssociationId", newAssociationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NewAssociationId":
            return Optional.of(clazz.cast(newAssociationId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, ReplaceNetworkAclAssociationResponse> {
        /**
         * <p>
         * The ID of the new association.
         * </p>
         * 
         * @param newAssociationId
         *        The ID of the new association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newAssociationId(String newAssociationId);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private String newAssociationId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplaceNetworkAclAssociationResponse model) {
            super(model);
            newAssociationId(model.newAssociationId);
        }

        public final String getNewAssociationId() {
            return newAssociationId;
        }

        @Override
        public final Builder newAssociationId(String newAssociationId) {
            this.newAssociationId = newAssociationId;
            return this;
        }

        public final void setNewAssociationId(String newAssociationId) {
            this.newAssociationId = newAssociationId;
        }

        @Override
        public ReplaceNetworkAclAssociationResponse build() {
            return new ReplaceNetworkAclAssociationResponse(this);
        }
    }
}
