/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a recurring charge.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RecurringCharge implements ToCopyableBuilder<RecurringCharge.Builder, RecurringCharge> {
    private final Double amount;

    private final String frequency;

    private RecurringCharge(BuilderImpl builder) {
        this.amount = builder.amount;
        this.frequency = builder.frequency;
    }

    /**
     * <p>
     * The amount of the recurring charge.
     * </p>
     * 
     * @return The amount of the recurring charge.
     */
    public Double amount() {
        return amount;
    }

    /**
     * <p>
     * The frequency of the recurring charge.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #frequency} will
     * return {@link RecurringChargeFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #frequencyAsString}.
     * </p>
     * 
     * @return The frequency of the recurring charge.
     * @see RecurringChargeFrequency
     */
    public RecurringChargeFrequency frequency() {
        return RecurringChargeFrequency.fromValue(frequency);
    }

    /**
     * <p>
     * The frequency of the recurring charge.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #frequency} will
     * return {@link RecurringChargeFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #frequencyAsString}.
     * </p>
     * 
     * @return The frequency of the recurring charge.
     * @see RecurringChargeFrequency
     */
    public String frequencyAsString() {
        return frequency;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amount());
        hashCode = 31 * hashCode + Objects.hashCode(frequencyAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecurringCharge)) {
            return false;
        }
        RecurringCharge other = (RecurringCharge) obj;
        return Objects.equals(amount(), other.amount()) && Objects.equals(frequencyAsString(), other.frequencyAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("RecurringCharge").add("Amount", amount()).add("Frequency", frequencyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Amount":
            return Optional.of(clazz.cast(amount()));
        case "Frequency":
            return Optional.of(clazz.cast(frequencyAsString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, RecurringCharge> {
        /**
         * <p>
         * The amount of the recurring charge.
         * </p>
         * 
         * @param amount
         *        The amount of the recurring charge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amount(Double amount);

        /**
         * <p>
         * The frequency of the recurring charge.
         * </p>
         * 
         * @param frequency
         *        The frequency of the recurring charge.
         * @see RecurringChargeFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecurringChargeFrequency
         */
        Builder frequency(String frequency);

        /**
         * <p>
         * The frequency of the recurring charge.
         * </p>
         * 
         * @param frequency
         *        The frequency of the recurring charge.
         * @see RecurringChargeFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecurringChargeFrequency
         */
        Builder frequency(RecurringChargeFrequency frequency);
    }

    static final class BuilderImpl implements Builder {
        private Double amount;

        private String frequency;

        private BuilderImpl() {
        }

        private BuilderImpl(RecurringCharge model) {
            amount(model.amount);
            frequency(model.frequency);
        }

        public final Double getAmount() {
            return amount;
        }

        @Override
        public final Builder amount(Double amount) {
            this.amount = amount;
            return this;
        }

        public final void setAmount(Double amount) {
            this.amount = amount;
        }

        public final String getFrequency() {
            return frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(RecurringChargeFrequency frequency) {
            this.frequency(frequency.toString());
            return this;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        @Override
        public RecurringCharge build() {
            return new RecurringCharge(this);
        }
    }
}
