/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for PurchaseScheduledInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PurchaseScheduledInstancesRequest extends EC2Request implements
        ToCopyableBuilder<PurchaseScheduledInstancesRequest.Builder, PurchaseScheduledInstancesRequest> {
    private final String clientToken;

    private final List<PurchaseRequest> purchaseRequests;

    private PurchaseScheduledInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.purchaseRequests = builder.purchaseRequests;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that ensures the idempotency of the request. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that ensures the idempotency of the request. For more information, see
     *         <a href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * One or more purchase requests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more purchase requests.
     */
    public List<PurchaseRequest> purchaseRequests() {
        return purchaseRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(purchaseRequests());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseScheduledInstancesRequest)) {
            return false;
        }
        PurchaseScheduledInstancesRequest other = (PurchaseScheduledInstancesRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(purchaseRequests(), other.purchaseRequests());
    }

    @Override
    public String toString() {
        return ToString.builder("PurchaseScheduledInstancesRequest").add("ClientToken", clientToken())
                .add("PurchaseRequests", purchaseRequests()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.of(clazz.cast(clientToken()));
        case "PurchaseRequests":
            return Optional.of(clazz.cast(purchaseRequests()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, PurchaseScheduledInstancesRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier that ensures the idempotency of the request. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that ensures the idempotency of the request. For more information,
         *        see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * One or more purchase requests.
         * </p>
         * 
         * @param purchaseRequests
         *        One or more purchase requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purchaseRequests(Collection<PurchaseRequest> purchaseRequests);

        /**
         * <p>
         * One or more purchase requests.
         * </p>
         * 
         * @param purchaseRequests
         *        One or more purchase requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purchaseRequests(PurchaseRequest... purchaseRequests);

        /**
         * <p>
         * One or more purchase requests.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PurchaseRequest>.Builder} avoiding the need
         * to create one manually via {@link List<PurchaseRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PurchaseRequest>.Builder#build()} is called immediately and
         * its result is passed to {@link #purchaseRequests(List<PurchaseRequest>)}.
         * 
         * @param purchaseRequests
         *        a consumer that will call methods on {@link List<PurchaseRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #purchaseRequests(List<PurchaseRequest>)
         */
        Builder purchaseRequests(Consumer<PurchaseRequest.Builder>... purchaseRequests);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String clientToken;

        private List<PurchaseRequest> purchaseRequests;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseScheduledInstancesRequest model) {
            super(model);
            clientToken(model.clientToken);
            purchaseRequests(model.purchaseRequests);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Collection<PurchaseRequest.Builder> getPurchaseRequests() {
            return purchaseRequests != null ? purchaseRequests.stream().map(PurchaseRequest::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder purchaseRequests(Collection<PurchaseRequest> purchaseRequests) {
            this.purchaseRequests = PurchaseRequestSetCopier.copy(purchaseRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purchaseRequests(PurchaseRequest... purchaseRequests) {
            purchaseRequests(Arrays.asList(purchaseRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purchaseRequests(Consumer<PurchaseRequest.Builder>... purchaseRequests) {
            purchaseRequests(Stream.of(purchaseRequests).map(c -> PurchaseRequest.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPurchaseRequests(Collection<PurchaseRequest.BuilderImpl> purchaseRequests) {
            this.purchaseRequests = PurchaseRequestSetCopier.copyFromBuilder(purchaseRequests);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PurchaseScheduledInstancesRequest build() {
            return new PurchaseScheduledInstancesRequest(this);
        }
    }
}
