/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PurchaseHostReservationRequest extends EC2Request implements
        ToCopyableBuilder<PurchaseHostReservationRequest.Builder, PurchaseHostReservationRequest> {
    private final String clientToken;

    private final String currencyCode;

    private final List<String> hostIdSet;

    private final String limitPrice;

    private final String offeringId;

    private PurchaseHostReservationRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.currencyCode = builder.currencyCode;
        this.hostIdSet = builder.hostIdSet;
        this.limitPrice = builder.limitPrice;
        this.offeringId = builder.offeringId;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
     * Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information,
     *         see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to
     *         Ensure Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The currency in which the <code>totalUpfrontPrice</code>, <code>LimitPrice</code>, and
     * <code>totalHourlyPrice</code> amounts are specified. At this time, the only supported currency is
     * <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The currency in which the <code>totalUpfrontPrice</code>, <code>LimitPrice</code>, and
     *         <code>totalHourlyPrice</code> amounts are specified. At this time, the only supported currency is
     *         <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(currencyCode);
    }

    /**
     * <p>
     * The currency in which the <code>totalUpfrontPrice</code>, <code>LimitPrice</code>, and
     * <code>totalHourlyPrice</code> amounts are specified. At this time, the only supported currency is
     * <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The currency in which the <code>totalUpfrontPrice</code>, <code>LimitPrice</code>, and
     *         <code>totalHourlyPrice</code> amounts are specified. At this time, the only supported currency is
     *         <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public String currencyCodeAsString() {
        return currencyCode;
    }

    /**
     * <p>
     * The ID/s of the Dedicated Host/s that the reservation will be associated with.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The ID/s of the Dedicated Host/s that the reservation will be associated with.
     */
    public List<String> hostIdSet() {
        return hostIdSet;
    }

    /**
     * <p>
     * The specified limit is checked against the total upfront cost of the reservation (calculated as the offering's
     * upfront cost multiplied by the host count). If the total upfront cost is greater than the specified price limit,
     * the request will fail. This is used to ensure that the purchase does not exceed the expected upfront cost of the
     * purchase. At this time, the only supported currency is <code>USD</code>. For example, to indicate a limit price
     * of USD 100, specify 100.00.
     * </p>
     * 
     * @return The specified limit is checked against the total upfront cost of the reservation (calculated as the
     *         offering's upfront cost multiplied by the host count). If the total upfront cost is greater than the
     *         specified price limit, the request will fail. This is used to ensure that the purchase does not exceed
     *         the expected upfront cost of the purchase. At this time, the only supported currency is <code>USD</code>.
     *         For example, to indicate a limit price of USD 100, specify 100.00.
     */
    public String limitPrice() {
        return limitPrice;
    }

    /**
     * <p>
     * The ID of the offering.
     * </p>
     * 
     * @return The ID of the offering.
     */
    public String offeringId() {
        return offeringId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hostIdSet());
        hashCode = 31 * hashCode + Objects.hashCode(limitPrice());
        hashCode = 31 * hashCode + Objects.hashCode(offeringId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseHostReservationRequest)) {
            return false;
        }
        PurchaseHostReservationRequest other = (PurchaseHostReservationRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(currencyCodeAsString(), other.currencyCodeAsString())
                && Objects.equals(hostIdSet(), other.hostIdSet()) && Objects.equals(limitPrice(), other.limitPrice())
                && Objects.equals(offeringId(), other.offeringId());
    }

    @Override
    public String toString() {
        return ToString.builder("PurchaseHostReservationRequest").add("ClientToken", clientToken())
                .add("CurrencyCode", currencyCodeAsString()).add("HostIdSet", hostIdSet()).add("LimitPrice", limitPrice())
                .add("OfferingId", offeringId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.of(clazz.cast(clientToken()));
        case "CurrencyCode":
            return Optional.of(clazz.cast(currencyCodeAsString()));
        case "HostIdSet":
            return Optional.of(clazz.cast(hostIdSet()));
        case "LimitPrice":
            return Optional.of(clazz.cast(limitPrice()));
        case "OfferingId":
            return Optional.of(clazz.cast(offeringId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, PurchaseHostReservationRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see
         * <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
         * Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
         *        Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The currency in which the <code>totalUpfrontPrice</code>, <code>LimitPrice</code>, and
         * <code>totalHourlyPrice</code> amounts are specified. At this time, the only supported currency is
         * <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency in which the <code>totalUpfrontPrice</code>, <code>LimitPrice</code>, and
         *        <code>totalHourlyPrice</code> amounts are specified. At this time, the only supported currency is
         *        <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The currency in which the <code>totalUpfrontPrice</code>, <code>LimitPrice</code>, and
         * <code>totalHourlyPrice</code> amounts are specified. At this time, the only supported currency is
         * <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency in which the <code>totalUpfrontPrice</code>, <code>LimitPrice</code>, and
         *        <code>totalHourlyPrice</code> amounts are specified. At this time, the only supported currency is
         *        <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(CurrencyCodeValues currencyCode);

        /**
         * <p>
         * The ID/s of the Dedicated Host/s that the reservation will be associated with.
         * </p>
         * 
         * @param hostIdSet
         *        The ID/s of the Dedicated Host/s that the reservation will be associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostIdSet(Collection<String> hostIdSet);

        /**
         * <p>
         * The ID/s of the Dedicated Host/s that the reservation will be associated with.
         * </p>
         * 
         * @param hostIdSet
         *        The ID/s of the Dedicated Host/s that the reservation will be associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostIdSet(String... hostIdSet);

        /**
         * <p>
         * The specified limit is checked against the total upfront cost of the reservation (calculated as the
         * offering's upfront cost multiplied by the host count). If the total upfront cost is greater than the
         * specified price limit, the request will fail. This is used to ensure that the purchase does not exceed the
         * expected upfront cost of the purchase. At this time, the only supported currency is <code>USD</code>. For
         * example, to indicate a limit price of USD 100, specify 100.00.
         * </p>
         * 
         * @param limitPrice
         *        The specified limit is checked against the total upfront cost of the reservation (calculated as the
         *        offering's upfront cost multiplied by the host count). If the total upfront cost is greater than the
         *        specified price limit, the request will fail. This is used to ensure that the purchase does not exceed
         *        the expected upfront cost of the purchase. At this time, the only supported currency is
         *        <code>USD</code>. For example, to indicate a limit price of USD 100, specify 100.00.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limitPrice(String limitPrice);

        /**
         * <p>
         * The ID of the offering.
         * </p>
         * 
         * @param offeringId
         *        The ID of the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringId(String offeringId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String clientToken;

        private String currencyCode;

        private List<String> hostIdSet;

        private String limitPrice;

        private String offeringId;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseHostReservationRequest model) {
            super(model);
            clientToken(model.clientToken);
            currencyCode(model.currencyCode);
            hostIdSet(model.hostIdSet);
            limitPrice(model.limitPrice);
            offeringId(model.offeringId);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Collection<String> getHostIdSet() {
            return hostIdSet;
        }

        @Override
        public final Builder hostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = RequestHostIdSetCopier.copy(hostIdSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostIdSet(String... hostIdSet) {
            hostIdSet(Arrays.asList(hostIdSet));
            return this;
        }

        public final void setHostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = RequestHostIdSetCopier.copy(hostIdSet);
        }

        public final String getLimitPrice() {
            return limitPrice;
        }

        @Override
        public final Builder limitPrice(String limitPrice) {
            this.limitPrice = limitPrice;
            return this;
        }

        public final void setLimitPrice(String limitPrice) {
            this.limitPrice = limitPrice;
        }

        public final String getOfferingId() {
            return offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PurchaseHostReservationRequest build() {
            return new PurchaseHostReservationRequest(this);
        }
    }
}
