/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a product code.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ProductCode implements ToCopyableBuilder<ProductCode.Builder, ProductCode> {
    private final String productCodeId;

    private final String productCodeType;

    private ProductCode(BuilderImpl builder) {
        this.productCodeId = builder.productCodeId;
        this.productCodeType = builder.productCodeType;
    }

    /**
     * <p>
     * The product code.
     * </p>
     * 
     * @return The product code.
     */
    public String productCodeId() {
        return productCodeId;
    }

    /**
     * <p>
     * The type of product code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productCodeType}
     * will return {@link ProductCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #productCodeTypeAsString}.
     * </p>
     * 
     * @return The type of product code.
     * @see ProductCodeValues
     */
    public ProductCodeValues productCodeType() {
        return ProductCodeValues.fromValue(productCodeType);
    }

    /**
     * <p>
     * The type of product code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productCodeType}
     * will return {@link ProductCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #productCodeTypeAsString}.
     * </p>
     * 
     * @return The type of product code.
     * @see ProductCodeValues
     */
    public String productCodeTypeAsString() {
        return productCodeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(productCodeId());
        hashCode = 31 * hashCode + Objects.hashCode(productCodeTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductCode)) {
            return false;
        }
        ProductCode other = (ProductCode) obj;
        return Objects.equals(productCodeId(), other.productCodeId())
                && Objects.equals(productCodeTypeAsString(), other.productCodeTypeAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("ProductCode").add("ProductCodeId", productCodeId())
                .add("ProductCodeType", productCodeTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProductCodeId":
            return Optional.of(clazz.cast(productCodeId()));
        case "ProductCodeType":
            return Optional.of(clazz.cast(productCodeTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ProductCode> {
        /**
         * <p>
         * The product code.
         * </p>
         * 
         * @param productCodeId
         *        The product code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodeId(String productCodeId);

        /**
         * <p>
         * The type of product code.
         * </p>
         * 
         * @param productCodeType
         *        The type of product code.
         * @see ProductCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProductCodeValues
         */
        Builder productCodeType(String productCodeType);

        /**
         * <p>
         * The type of product code.
         * </p>
         * 
         * @param productCodeType
         *        The type of product code.
         * @see ProductCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProductCodeValues
         */
        Builder productCodeType(ProductCodeValues productCodeType);
    }

    static final class BuilderImpl implements Builder {
        private String productCodeId;

        private String productCodeType;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductCode model) {
            productCodeId(model.productCodeId);
            productCodeType(model.productCodeType);
        }

        public final String getProductCodeId() {
            return productCodeId;
        }

        @Override
        public final Builder productCodeId(String productCodeId) {
            this.productCodeId = productCodeId;
            return this;
        }

        public final void setProductCodeId(String productCodeId) {
            this.productCodeId = productCodeId;
        }

        public final String getProductCodeType() {
            return productCodeType;
        }

        @Override
        public final Builder productCodeType(String productCodeType) {
            this.productCodeType = productCodeType;
            return this;
        }

        @Override
        public final Builder productCodeType(ProductCodeValues productCodeType) {
            this.productCodeType(productCodeType.toString());
            return this;
        }

        public final void setProductCodeType(String productCodeType) {
            this.productCodeType = productCodeType;
        }

        @Override
        public ProductCode build() {
            return new ProductCode(this);
        }
    }
}
