/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the placement of an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Placement implements ToCopyableBuilder<Placement.Builder, Placement> {
    private final String availabilityZone;

    private final String affinity;

    private final String groupName;

    private final String hostId;

    private final String tenancy;

    private final String spreadDomain;

    private Placement(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.affinity = builder.affinity;
        this.groupName = builder.groupName;
        this.hostId = builder.hostId;
        this.tenancy = builder.tenancy;
        this.spreadDomain = builder.spreadDomain;
    }

    /**
     * <p>
     * The Availability Zone of the instance.
     * </p>
     * 
     * @return The Availability Zone of the instance.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The affinity setting for the instance on the Dedicated Host. This parameter is not supported for the
     * <a>ImportInstance</a> command.
     * </p>
     * 
     * @return The affinity setting for the instance on the Dedicated Host. This parameter is not supported for the
     *         <a>ImportInstance</a> command.
     */
    public String affinity() {
        return affinity;
    }

    /**
     * <p>
     * The name of the placement group the instance is in (for cluster compute instances).
     * </p>
     * 
     * @return The name of the placement group the instance is in (for cluster compute instances).
     */
    public String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The ID of the Dedicated Host on which the instance resides. This parameter is not supported for the
     * <a>ImportInstance</a> command.
     * </p>
     * 
     * @return The ID of the Dedicated Host on which the instance resides. This parameter is not supported for the
     *         <a>ImportInstance</a> command.
     */
    public String hostId() {
        return hostId;
    }

    /**
     * <p>
     * The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
     * <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for the
     * <a>ImportInstance</a> command.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tenancyAsString}.
     * </p>
     * 
     * @return The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
     *         <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for
     *         the <a>ImportInstance</a> command.
     * @see Tenancy
     */
    public Tenancy tenancy() {
        return Tenancy.fromValue(tenancy);
    }

    /**
     * <p>
     * The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
     * <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for the
     * <a>ImportInstance</a> command.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tenancyAsString}.
     * </p>
     * 
     * @return The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
     *         <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for
     *         the <a>ImportInstance</a> command.
     * @see Tenancy
     */
    public String tenancyAsString() {
        return tenancy;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public String spreadDomain() {
        return spreadDomain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(affinity());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(hostId());
        hashCode = 31 * hashCode + Objects.hashCode(tenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(spreadDomain());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Placement)) {
            return false;
        }
        Placement other = (Placement) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(affinity(), other.affinity())
                && Objects.equals(groupName(), other.groupName()) && Objects.equals(hostId(), other.hostId())
                && Objects.equals(tenancyAsString(), other.tenancyAsString())
                && Objects.equals(spreadDomain(), other.spreadDomain());
    }

    @Override
    public String toString() {
        return ToString.builder("Placement").add("AvailabilityZone", availabilityZone()).add("Affinity", affinity())
                .add("GroupName", groupName()).add("HostId", hostId()).add("Tenancy", tenancyAsString())
                .add("SpreadDomain", spreadDomain()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.of(clazz.cast(availabilityZone()));
        case "Affinity":
            return Optional.of(clazz.cast(affinity()));
        case "GroupName":
            return Optional.of(clazz.cast(groupName()));
        case "HostId":
            return Optional.of(clazz.cast(hostId()));
        case "Tenancy":
            return Optional.of(clazz.cast(tenancyAsString()));
        case "SpreadDomain":
            return Optional.of(clazz.cast(spreadDomain()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Placement> {
        /**
         * <p>
         * The Availability Zone of the instance.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The affinity setting for the instance on the Dedicated Host. This parameter is not supported for the
         * <a>ImportInstance</a> command.
         * </p>
         * 
         * @param affinity
         *        The affinity setting for the instance on the Dedicated Host. This parameter is not supported for the
         *        <a>ImportInstance</a> command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder affinity(String affinity);

        /**
         * <p>
         * The name of the placement group the instance is in (for cluster compute instances).
         * </p>
         * 
         * @param groupName
         *        The name of the placement group the instance is in (for cluster compute instances).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The ID of the Dedicated Host on which the instance resides. This parameter is not supported for the
         * <a>ImportInstance</a> command.
         * </p>
         * 
         * @param hostId
         *        The ID of the Dedicated Host on which the instance resides. This parameter is not supported for the
         *        <a>ImportInstance</a> command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostId(String hostId);

        /**
         * <p>
         * The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
         * <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for the
         * <a>ImportInstance</a> command.
         * </p>
         * 
         * @param tenancy
         *        The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
         *        <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported
         *        for the <a>ImportInstance</a> command.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder tenancy(String tenancy);

        /**
         * <p>
         * The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
         * <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for the
         * <a>ImportInstance</a> command.
         * </p>
         * 
         * @param tenancy
         *        The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
         *        <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported
         *        for the <a>ImportInstance</a> command.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder tenancy(Tenancy tenancy);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param spreadDomain
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spreadDomain(String spreadDomain);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private String affinity;

        private String groupName;

        private String hostId;

        private String tenancy;

        private String spreadDomain;

        private BuilderImpl() {
        }

        private BuilderImpl(Placement model) {
            availabilityZone(model.availabilityZone);
            affinity(model.affinity);
            groupName(model.groupName);
            hostId(model.hostId);
            tenancy(model.tenancy);
            spreadDomain(model.spreadDomain);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getAffinity() {
            return affinity;
        }

        @Override
        public final Builder affinity(String affinity) {
            this.affinity = affinity;
            return this;
        }

        public final void setAffinity(String affinity) {
            this.affinity = affinity;
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getHostId() {
            return hostId;
        }

        @Override
        public final Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        public final void setHostId(String hostId) {
            this.hostId = hostId;
        }

        public final String getTenancy() {
            return tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(Tenancy tenancy) {
            this.tenancy(tenancy.toString());
            return this;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        public final String getSpreadDomain() {
            return spreadDomain;
        }

        @Override
        public final Builder spreadDomain(String spreadDomain) {
            this.spreadDomain = spreadDomain;
            return this;
        }

        public final void setSpreadDomain(String spreadDomain) {
            this.spreadDomain = spreadDomain;
        }

        @Override
        public Placement build() {
            return new Placement(this);
        }
    }
}
