/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ModifyVpcAttribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ModifyVpcAttributeRequest extends EC2Request implements
        ToCopyableBuilder<ModifyVpcAttributeRequest.Builder, ModifyVpcAttributeRequest> {
    private final Boolean enableDnsHostnames;

    private final Boolean enableDnsSupport;

    private final String vpcId;

    private ModifyVpcAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.enableDnsHostnames = builder.enableDnsHostnames;
        this.enableDnsSupport = builder.enableDnsSupport;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * Indicates whether the instances launched in the VPC get DNS hostnames. If enabled, instances in the VPC get DNS
     * hostnames; otherwise, they do not.
     * </p>
     * <p>
     * You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate requests for
     * each attribute. You can only enable DNS hostnames if you've enabled DNS support.
     * </p>
     * 
     * @return Indicates whether the instances launched in the VPC get DNS hostnames. If enabled, instances in the VPC
     *         get DNS hostnames; otherwise, they do not.</p>
     *         <p>
     *         You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate
     *         requests for each attribute. You can only enable DNS hostnames if you've enabled DNS support.
     */
    public Boolean enableDnsHostnames() {
        return enableDnsHostnames;
    }

    /**
     * <p>
     * Indicates whether the DNS resolution is supported for the VPC. If enabled, queries to the Amazon provided DNS
     * server at the 169.254.169.253 IP address, or the reserved IP address at the base of the VPC network range
     * "plus two" will succeed. If disabled, the Amazon provided DNS service in the VPC that resolves public DNS
     * hostnames to IP addresses is not enabled.
     * </p>
     * <p>
     * You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate requests for
     * each attribute.
     * </p>
     * 
     * @return Indicates whether the DNS resolution is supported for the VPC. If enabled, queries to the Amazon provided
     *         DNS server at the 169.254.169.253 IP address, or the reserved IP address at the base of the VPC network
     *         range "plus two" will succeed. If disabled, the Amazon provided DNS service in the VPC that resolves
     *         public DNS hostnames to IP addresses is not enabled.</p>
     *         <p>
     *         You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate
     *         requests for each attribute.
     */
    public Boolean enableDnsSupport() {
        return enableDnsSupport;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableDnsHostnames());
        hashCode = 31 * hashCode + Objects.hashCode(enableDnsSupport());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcAttributeRequest)) {
            return false;
        }
        ModifyVpcAttributeRequest other = (ModifyVpcAttributeRequest) obj;
        return Objects.equals(enableDnsHostnames(), other.enableDnsHostnames())
                && Objects.equals(enableDnsSupport(), other.enableDnsSupport()) && Objects.equals(vpcId(), other.vpcId());
    }

    @Override
    public String toString() {
        return ToString.builder("ModifyVpcAttributeRequest").add("EnableDnsHostnames", enableDnsHostnames())
                .add("EnableDnsSupport", enableDnsSupport()).add("VpcId", vpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableDnsHostnames":
            return Optional.of(clazz.cast(enableDnsHostnames()));
        case "EnableDnsSupport":
            return Optional.of(clazz.cast(enableDnsSupport()));
        case "VpcId":
            return Optional.of(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, ModifyVpcAttributeRequest> {
        /**
         * <p>
         * Indicates whether the instances launched in the VPC get DNS hostnames. If enabled, instances in the VPC get
         * DNS hostnames; otherwise, they do not.
         * </p>
         * <p>
         * You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate requests
         * for each attribute. You can only enable DNS hostnames if you've enabled DNS support.
         * </p>
         * 
         * @param enableDnsHostnames
         *        Indicates whether the instances launched in the VPC get DNS hostnames. If enabled, instances in the
         *        VPC get DNS hostnames; otherwise, they do not.</p>
         *        <p>
         *        You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate
         *        requests for each attribute. You can only enable DNS hostnames if you've enabled DNS support.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableDnsHostnames(Boolean enableDnsHostnames);

        /**
         * <p>
         * Indicates whether the DNS resolution is supported for the VPC. If enabled, queries to the Amazon provided DNS
         * server at the 169.254.169.253 IP address, or the reserved IP address at the base of the VPC network range
         * "plus two" will succeed. If disabled, the Amazon provided DNS service in the VPC that resolves public DNS
         * hostnames to IP addresses is not enabled.
         * </p>
         * <p>
         * You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate requests
         * for each attribute.
         * </p>
         * 
         * @param enableDnsSupport
         *        Indicates whether the DNS resolution is supported for the VPC. If enabled, queries to the Amazon
         *        provided DNS server at the 169.254.169.253 IP address, or the reserved IP address at the base of the
         *        VPC network range "plus two" will succeed. If disabled, the Amazon provided DNS service in the VPC
         *        that resolves public DNS hostnames to IP addresses is not enabled.</p>
         *        <p>
         *        You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate
         *        requests for each attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableDnsSupport(Boolean enableDnsSupport);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private Boolean enableDnsHostnames;

        private Boolean enableDnsSupport;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcAttributeRequest model) {
            super(model);
            enableDnsHostnames(model.enableDnsHostnames);
            enableDnsSupport(model.enableDnsSupport);
            vpcId(model.vpcId);
        }

        public final Boolean getEnableDnsHostnames() {
            return enableDnsHostnames;
        }

        @Override
        public final Builder enableDnsHostnames(Boolean enableDnsHostnames) {
            this.enableDnsHostnames = enableDnsHostnames;
            return this;
        }

        public final void setEnableDnsHostnames(Boolean enableDnsHostnames) {
            this.enableDnsHostnames = enableDnsHostnames;
        }

        public final Boolean getEnableDnsSupport() {
            return enableDnsSupport;
        }

        @Override
        public final Builder enableDnsSupport(Boolean enableDnsSupport) {
            this.enableDnsSupport = enableDnsSupport;
            return this;
        }

        public final void setEnableDnsSupport(Boolean enableDnsSupport) {
            this.enableDnsSupport = enableDnsSupport;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpcAttributeRequest build() {
            return new ModifyVpcAttributeRequest(this);
        }
    }
}
