/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ModifyVolumeResponse extends EC2Response implements
        ToCopyableBuilder<ModifyVolumeResponse.Builder, ModifyVolumeResponse> {
    private final VolumeModification volumeModification;

    private ModifyVolumeResponse(BuilderImpl builder) {
        super(builder);
        this.volumeModification = builder.volumeModification;
    }

    /**
     * <p>
     * A <a>VolumeModification</a> object.
     * </p>
     * 
     * @return A <a>VolumeModification</a> object.
     */
    public VolumeModification volumeModification() {
        return volumeModification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volumeModification());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVolumeResponse)) {
            return false;
        }
        ModifyVolumeResponse other = (ModifyVolumeResponse) obj;
        return Objects.equals(volumeModification(), other.volumeModification());
    }

    @Override
    public String toString() {
        return ToString.builder("ModifyVolumeResponse").add("VolumeModification", volumeModification()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeModification":
            return Optional.of(clazz.cast(volumeModification()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, ModifyVolumeResponse> {
        /**
         * <p>
         * A <a>VolumeModification</a> object.
         * </p>
         * 
         * @param volumeModification
         *        A <a>VolumeModification</a> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeModification(VolumeModification volumeModification);

        /**
         * <p>
         * A <a>VolumeModification</a> object.
         * </p>
         * This is a convenience that creates an instance of the {@link VolumeModification.Builder} avoiding the need to
         * create one manually via {@link VolumeModification#builder()}.
         *
         * When the {@link Consumer} completes, {@link VolumeModification.Builder#build()} is called immediately and its
         * result is passed to {@link #volumeModification(VolumeModification)}.
         * 
         * @param volumeModification
         *        a consumer that will call methods on {@link VolumeModification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumeModification(VolumeModification)
         */
        default Builder volumeModification(Consumer<VolumeModification.Builder> volumeModification) {
            return volumeModification(VolumeModification.builder().apply(volumeModification).build());
        }
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private VolumeModification volumeModification;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVolumeResponse model) {
            super(model);
            volumeModification(model.volumeModification);
        }

        public final VolumeModification.Builder getVolumeModification() {
            return volumeModification != null ? volumeModification.toBuilder() : null;
        }

        @Override
        public final Builder volumeModification(VolumeModification volumeModification) {
            this.volumeModification = volumeModification;
            return this;
        }

        public final void setVolumeModification(VolumeModification.BuilderImpl volumeModification) {
            this.volumeModification = volumeModification != null ? volumeModification.build() : null;
        }

        @Override
        public ModifyVolumeResponse build() {
            return new ModifyVolumeResponse(this);
        }
    }
}
