/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ModifyVolumeRequest extends EC2Request implements
        ToCopyableBuilder<ModifyVolumeRequest.Builder, ModifyVolumeRequest> {
    private final String volumeId;

    private final Integer size;

    private final String volumeType;

    private final Integer iops;

    private ModifyVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.volumeId = builder.volumeId;
        this.size = builder.size;
        this.volumeType = builder.volumeType;
        this.iops = builder.iops;
    }

    /**
     * Returns the value of the VolumeId property for this object.
     * 
     * @return The value of the VolumeId property for this object.
     */
    public String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * Target size in GiB of the volume to be modified. Target volume size must be greater than or equal to than the
     * existing size of the volume. For information about available EBS volume sizes, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html"
     * >http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html</a>.
     * </p>
     * <p>
     * Default: If no size is specified, the existing size is retained.
     * </p>
     * 
     * @return Target size in GiB of the volume to be modified. Target volume size must be greater than or equal to than
     *         the existing size of the volume. For information about available EBS volume sizes, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html"
     *         >http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html</a>.</p>
     *         <p>
     *         Default: If no size is specified, the existing size is retained.
     */
    public Integer size() {
        return size;
    }

    /**
     * <p>
     * Target EBS volume type of the volume to be modified
     * </p>
     * <p>
     * The API does not support modifications for volume type <code>standard</code>. You also cannot change the type of
     * a volume to <code>standard</code>.
     * </p>
     * <p>
     * Default: If no type is specified, the existing type is retained.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return Target EBS volume type of the volume to be modified</p>
     *         <p>
     *         The API does not support modifications for volume type <code>standard</code>. You also cannot change the
     *         type of a volume to <code>standard</code>.
     *         </p>
     *         <p>
     *         Default: If no type is specified, the existing type is retained.
     * @see VolumeType
     */
    public VolumeType volumeType() {
        return VolumeType.fromValue(volumeType);
    }

    /**
     * <p>
     * Target EBS volume type of the volume to be modified
     * </p>
     * <p>
     * The API does not support modifications for volume type <code>standard</code>. You also cannot change the type of
     * a volume to <code>standard</code>.
     * </p>
     * <p>
     * Default: If no type is specified, the existing type is retained.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return Target EBS volume type of the volume to be modified</p>
     *         <p>
     *         The API does not support modifications for volume type <code>standard</code>. You also cannot change the
     *         type of a volume to <code>standard</code>.
     *         </p>
     *         <p>
     *         Default: If no type is specified, the existing type is retained.
     * @see VolumeType
     */
    public String volumeTypeAsString() {
        return volumeType;
    }

    /**
     * <p>
     * Target IOPS rate of the volume to be modified.
     * </p>
     * <p>
     * Only valid for Provisioned IOPS SSD (<code>io1</code>) volumes. For more information about <code>io1</code> IOPS
     * configuration, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html#EBSVolumeTypes_piops"
     * >http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html#EBSVolumeTypes_piops</a>.
     * </p>
     * <p>
     * Default: If no IOPS value is specified, the existing value is retained.
     * </p>
     * 
     * @return Target IOPS rate of the volume to be modified.</p>
     *         <p>
     *         Only valid for Provisioned IOPS SSD (<code>io1</code>) volumes. For more information about
     *         <code>io1</code> IOPS configuration, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html#EBSVolumeTypes_piops"
     *         >http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html#EBSVolumeTypes_piops</a>.
     *         </p>
     *         <p>
     *         Default: If no IOPS value is specified, the existing value is retained.
     */
    public Integer iops() {
        return iops;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        hashCode = 31 * hashCode + Objects.hashCode(volumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVolumeRequest)) {
            return false;
        }
        ModifyVolumeRequest other = (ModifyVolumeRequest) obj;
        return Objects.equals(volumeId(), other.volumeId()) && Objects.equals(size(), other.size())
                && Objects.equals(volumeTypeAsString(), other.volumeTypeAsString()) && Objects.equals(iops(), other.iops());
    }

    @Override
    public String toString() {
        return ToString.builder("ModifyVolumeRequest").add("VolumeId", volumeId()).add("Size", size())
                .add("VolumeType", volumeTypeAsString()).add("Iops", iops()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeId":
            return Optional.of(clazz.cast(volumeId()));
        case "Size":
            return Optional.of(clazz.cast(size()));
        case "VolumeType":
            return Optional.of(clazz.cast(volumeTypeAsString()));
        case "Iops":
            return Optional.of(clazz.cast(iops()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, ModifyVolumeRequest> {
        /**
         * Sets the value of the VolumeId property for this object.
         *
         * @param volumeId
         *        The new value for the VolumeId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * Target size in GiB of the volume to be modified. Target volume size must be greater than or equal to than the
         * existing size of the volume. For information about available EBS volume sizes, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html"
         * >http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html</a>.
         * </p>
         * <p>
         * Default: If no size is specified, the existing size is retained.
         * </p>
         * 
         * @param size
         *        Target size in GiB of the volume to be modified. Target volume size must be greater than or equal to
         *        than the existing size of the volume. For information about available EBS volume sizes, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html"
         *        >http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html</a>.</p>
         *        <p>
         *        Default: If no size is specified, the existing size is retained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);

        /**
         * <p>
         * Target EBS volume type of the volume to be modified
         * </p>
         * <p>
         * The API does not support modifications for volume type <code>standard</code>. You also cannot change the type
         * of a volume to <code>standard</code>.
         * </p>
         * <p>
         * Default: If no type is specified, the existing type is retained.
         * </p>
         * 
         * @param volumeType
         *        Target EBS volume type of the volume to be modified</p>
         *        <p>
         *        The API does not support modifications for volume type <code>standard</code>. You also cannot change
         *        the type of a volume to <code>standard</code>.
         *        </p>
         *        <p>
         *        Default: If no type is specified, the existing type is retained.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * Target EBS volume type of the volume to be modified
         * </p>
         * <p>
         * The API does not support modifications for volume type <code>standard</code>. You also cannot change the type
         * of a volume to <code>standard</code>.
         * </p>
         * <p>
         * Default: If no type is specified, the existing type is retained.
         * </p>
         * 
         * @param volumeType
         *        Target EBS volume type of the volume to be modified</p>
         *        <p>
         *        The API does not support modifications for volume type <code>standard</code>. You also cannot change
         *        the type of a volume to <code>standard</code>.
         *        </p>
         *        <p>
         *        Default: If no type is specified, the existing type is retained.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(VolumeType volumeType);

        /**
         * <p>
         * Target IOPS rate of the volume to be modified.
         * </p>
         * <p>
         * Only valid for Provisioned IOPS SSD (<code>io1</code>) volumes. For more information about <code>io1</code>
         * IOPS configuration, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html#EBSVolumeTypes_piops"
         * >http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html#EBSVolumeTypes_piops</a>.
         * </p>
         * <p>
         * Default: If no IOPS value is specified, the existing value is retained.
         * </p>
         * 
         * @param iops
         *        Target IOPS rate of the volume to be modified.</p>
         *        <p>
         *        Only valid for Provisioned IOPS SSD (<code>io1</code>) volumes. For more information about
         *        <code>io1</code> IOPS configuration, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html#EBSVolumeTypes_piops"
         *        >http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html#EBSVolumeTypes_piops</a>.
         *        </p>
         *        <p>
         *        Default: If no IOPS value is specified, the existing value is retained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String volumeId;

        private Integer size;

        private String volumeType;

        private Integer iops;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVolumeRequest model) {
            super(model);
            volumeId(model.volumeId);
            size(model.size);
            volumeType(model.volumeType);
            iops(model.iops);
        }

        public final String getVolumeId() {
            return volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public final Integer getSize() {
            return size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType.toString());
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        public final Integer getIops() {
            return iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ModifyVolumeRequest build() {
            return new ModifyVolumeRequest(this);
        }
    }
}
