/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ModifyVolumeAttribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ModifyVolumeAttributeRequest extends EC2Request implements
        ToCopyableBuilder<ModifyVolumeAttributeRequest.Builder, ModifyVolumeAttributeRequest> {
    private final Boolean autoEnableIO;

    private final String volumeId;

    private ModifyVolumeAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.autoEnableIO = builder.autoEnableIO;
        this.volumeId = builder.volumeId;
    }

    /**
     * <p>
     * Indicates whether the volume should be auto-enabled for I/O operations.
     * </p>
     * 
     * @return Indicates whether the volume should be auto-enabled for I/O operations.
     */
    public Boolean autoEnableIO() {
        return autoEnableIO;
    }

    /**
     * <p>
     * The ID of the volume.
     * </p>
     * 
     * @return The ID of the volume.
     */
    public String volumeId() {
        return volumeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoEnableIO());
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVolumeAttributeRequest)) {
            return false;
        }
        ModifyVolumeAttributeRequest other = (ModifyVolumeAttributeRequest) obj;
        return Objects.equals(autoEnableIO(), other.autoEnableIO()) && Objects.equals(volumeId(), other.volumeId());
    }

    @Override
    public String toString() {
        return ToString.builder("ModifyVolumeAttributeRequest").add("AutoEnableIO", autoEnableIO()).add("VolumeId", volumeId())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoEnableIO":
            return Optional.of(clazz.cast(autoEnableIO()));
        case "VolumeId":
            return Optional.of(clazz.cast(volumeId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, ModifyVolumeAttributeRequest> {
        /**
         * <p>
         * Indicates whether the volume should be auto-enabled for I/O operations.
         * </p>
         * 
         * @param autoEnableIO
         *        Indicates whether the volume should be auto-enabled for I/O operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoEnableIO(Boolean autoEnableIO);

        /**
         * <p>
         * The ID of the volume.
         * </p>
         * 
         * @param volumeId
         *        The ID of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private Boolean autoEnableIO;

        private String volumeId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVolumeAttributeRequest model) {
            super(model);
            autoEnableIO(model.autoEnableIO);
            volumeId(model.volumeId);
        }

        public final Boolean getAutoEnableIO() {
            return autoEnableIO;
        }

        @Override
        public final Builder autoEnableIO(Boolean autoEnableIO) {
            this.autoEnableIO = autoEnableIO;
            return this;
        }

        public final void setAutoEnableIO(Boolean autoEnableIO) {
            this.autoEnableIO = autoEnableIO;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ModifyVolumeAttributeRequest build() {
            return new ModifyVolumeAttributeRequest(this);
        }
    }
}
