/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ModifySpotFleetRequest.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ModifySpotFleetRequestRequest extends EC2Request implements
        ToCopyableBuilder<ModifySpotFleetRequestRequest.Builder, ModifySpotFleetRequestRequest> {
    private final String excessCapacityTerminationPolicy;

    private final String spotFleetRequestId;

    private final Integer targetCapacity;

    private ModifySpotFleetRequestRequest(BuilderImpl builder) {
        super(builder);
        this.excessCapacityTerminationPolicy = builder.excessCapacityTerminationPolicy;
        this.spotFleetRequestId = builder.spotFleetRequestId;
        this.targetCapacity = builder.targetCapacity;
    }

    /**
     * <p>
     * Indicates whether running Spot instances should be terminated if the target capacity of the Spot fleet request is
     * decreased below the current size of the Spot fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #excessCapacityTerminationPolicy} will return
     * {@link ExcessCapacityTerminationPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #excessCapacityTerminationPolicyAsString}.
     * </p>
     * 
     * @return Indicates whether running Spot instances should be terminated if the target capacity of the Spot fleet
     *         request is decreased below the current size of the Spot fleet.
     * @see ExcessCapacityTerminationPolicy
     */
    public ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy() {
        return ExcessCapacityTerminationPolicy.fromValue(excessCapacityTerminationPolicy);
    }

    /**
     * <p>
     * Indicates whether running Spot instances should be terminated if the target capacity of the Spot fleet request is
     * decreased below the current size of the Spot fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #excessCapacityTerminationPolicy} will return
     * {@link ExcessCapacityTerminationPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #excessCapacityTerminationPolicyAsString}.
     * </p>
     * 
     * @return Indicates whether running Spot instances should be terminated if the target capacity of the Spot fleet
     *         request is decreased below the current size of the Spot fleet.
     * @see ExcessCapacityTerminationPolicy
     */
    public String excessCapacityTerminationPolicyAsString() {
        return excessCapacityTerminationPolicy;
    }

    /**
     * <p>
     * The ID of the Spot fleet request.
     * </p>
     * 
     * @return The ID of the Spot fleet request.
     */
    public String spotFleetRequestId() {
        return spotFleetRequestId;
    }

    /**
     * <p>
     * The size of the fleet.
     * </p>
     * 
     * @return The size of the fleet.
     */
    public Integer targetCapacity() {
        return targetCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(excessCapacityTerminationPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(spotFleetRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(targetCapacity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifySpotFleetRequestRequest)) {
            return false;
        }
        ModifySpotFleetRequestRequest other = (ModifySpotFleetRequestRequest) obj;
        return Objects.equals(excessCapacityTerminationPolicyAsString(), other.excessCapacityTerminationPolicyAsString())
                && Objects.equals(spotFleetRequestId(), other.spotFleetRequestId())
                && Objects.equals(targetCapacity(), other.targetCapacity());
    }

    @Override
    public String toString() {
        return ToString.builder("ModifySpotFleetRequestRequest")
                .add("ExcessCapacityTerminationPolicy", excessCapacityTerminationPolicyAsString())
                .add("SpotFleetRequestId", spotFleetRequestId()).add("TargetCapacity", targetCapacity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExcessCapacityTerminationPolicy":
            return Optional.of(clazz.cast(excessCapacityTerminationPolicyAsString()));
        case "SpotFleetRequestId":
            return Optional.of(clazz.cast(spotFleetRequestId()));
        case "TargetCapacity":
            return Optional.of(clazz.cast(targetCapacity()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, ModifySpotFleetRequestRequest> {
        /**
         * <p>
         * Indicates whether running Spot instances should be terminated if the target capacity of the Spot fleet
         * request is decreased below the current size of the Spot fleet.
         * </p>
         * 
         * @param excessCapacityTerminationPolicy
         *        Indicates whether running Spot instances should be terminated if the target capacity of the Spot fleet
         *        request is decreased below the current size of the Spot fleet.
         * @see ExcessCapacityTerminationPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExcessCapacityTerminationPolicy
         */
        Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy);

        /**
         * <p>
         * Indicates whether running Spot instances should be terminated if the target capacity of the Spot fleet
         * request is decreased below the current size of the Spot fleet.
         * </p>
         * 
         * @param excessCapacityTerminationPolicy
         *        Indicates whether running Spot instances should be terminated if the target capacity of the Spot fleet
         *        request is decreased below the current size of the Spot fleet.
         * @see ExcessCapacityTerminationPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExcessCapacityTerminationPolicy
         */
        Builder excessCapacityTerminationPolicy(ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy);

        /**
         * <p>
         * The ID of the Spot fleet request.
         * </p>
         * 
         * @param spotFleetRequestId
         *        The ID of the Spot fleet request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestId(String spotFleetRequestId);

        /**
         * <p>
         * The size of the fleet.
         * </p>
         * 
         * @param targetCapacity
         *        The size of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCapacity(Integer targetCapacity);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String excessCapacityTerminationPolicy;

        private String spotFleetRequestId;

        private Integer targetCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifySpotFleetRequestRequest model) {
            super(model);
            excessCapacityTerminationPolicy(model.excessCapacityTerminationPolicy);
            spotFleetRequestId(model.spotFleetRequestId);
            targetCapacity(model.targetCapacity);
        }

        public final String getExcessCapacityTerminationPolicy() {
            return excessCapacityTerminationPolicy;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
            return this;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy(excessCapacityTerminationPolicy.toString());
            return this;
        }

        public final void setExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
        }

        public final String getSpotFleetRequestId() {
            return spotFleetRequestId;
        }

        @Override
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        public final Integer getTargetCapacity() {
            return targetCapacity;
        }

        @Override
        public final Builder targetCapacity(Integer targetCapacity) {
            this.targetCapacity = targetCapacity;
            return this;
        }

        public final void setTargetCapacity(Integer targetCapacity) {
            this.targetCapacity = targetCapacity;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ModifySpotFleetRequestRequest build() {
            return new ModifySpotFleetRequestRequest(this);
        }
    }
}
