/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of ModifyHosts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ModifyHostsResponse extends EC2Response implements
        ToCopyableBuilder<ModifyHostsResponse.Builder, ModifyHostsResponse> {
    private final List<String> successful;

    private final List<UnsuccessfulItem> unsuccessful;

    private ModifyHostsResponse(BuilderImpl builder) {
        super(builder);
        this.successful = builder.successful;
        this.unsuccessful = builder.unsuccessful;
    }

    /**
     * <p>
     * The IDs of the Dedicated Hosts that were successfully modified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the Dedicated Hosts that were successfully modified.
     */
    public List<String> successful() {
        return successful;
    }

    /**
     * <p>
     * The IDs of the Dedicated Hosts that could not be modified. Check whether the setting you requested can be used.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the Dedicated Hosts that could not be modified. Check whether the setting you requested can be
     *         used.
     */
    public List<UnsuccessfulItem> unsuccessful() {
        return unsuccessful;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(successful());
        hashCode = 31 * hashCode + Objects.hashCode(unsuccessful());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyHostsResponse)) {
            return false;
        }
        ModifyHostsResponse other = (ModifyHostsResponse) obj;
        return Objects.equals(successful(), other.successful()) && Objects.equals(unsuccessful(), other.unsuccessful());
    }

    @Override
    public String toString() {
        return ToString.builder("ModifyHostsResponse").add("Successful", successful()).add("Unsuccessful", unsuccessful())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Successful":
            return Optional.of(clazz.cast(successful()));
        case "Unsuccessful":
            return Optional.of(clazz.cast(unsuccessful()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, ModifyHostsResponse> {
        /**
         * <p>
         * The IDs of the Dedicated Hosts that were successfully modified.
         * </p>
         * 
         * @param successful
         *        The IDs of the Dedicated Hosts that were successfully modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(Collection<String> successful);

        /**
         * <p>
         * The IDs of the Dedicated Hosts that were successfully modified.
         * </p>
         * 
         * @param successful
         *        The IDs of the Dedicated Hosts that were successfully modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(String... successful);

        /**
         * <p>
         * The IDs of the Dedicated Hosts that could not be modified. Check whether the setting you requested can be
         * used.
         * </p>
         * 
         * @param unsuccessful
         *        The IDs of the Dedicated Hosts that could not be modified. Check whether the setting you requested can
         *        be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessful(Collection<UnsuccessfulItem> unsuccessful);

        /**
         * <p>
         * The IDs of the Dedicated Hosts that could not be modified. Check whether the setting you requested can be
         * used.
         * </p>
         * 
         * @param unsuccessful
         *        The IDs of the Dedicated Hosts that could not be modified. Check whether the setting you requested can
         *        be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessful(UnsuccessfulItem... unsuccessful);

        /**
         * <p>
         * The IDs of the Dedicated Hosts that could not be modified. Check whether the setting you requested can be
         * used.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UnsuccessfulItem>.Builder} avoiding the
         * need to create one manually via {@link List<UnsuccessfulItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UnsuccessfulItem>.Builder#build()} is called immediately and
         * its result is passed to {@link #unsuccessful(List<UnsuccessfulItem>)}.
         * 
         * @param unsuccessful
         *        a consumer that will call methods on {@link List<UnsuccessfulItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unsuccessful(List<UnsuccessfulItem>)
         */
        Builder unsuccessful(Consumer<UnsuccessfulItem.Builder>... unsuccessful);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<String> successful;

        private List<UnsuccessfulItem> unsuccessful;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyHostsResponse model) {
            super(model);
            successful(model.successful);
            unsuccessful(model.unsuccessful);
        }

        public final Collection<String> getSuccessful() {
            return successful;
        }

        @Override
        public final Builder successful(Collection<String> successful) {
            this.successful = ResponseHostIdListCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(String... successful) {
            successful(Arrays.asList(successful));
            return this;
        }

        public final void setSuccessful(Collection<String> successful) {
            this.successful = ResponseHostIdListCopier.copy(successful);
        }

        public final Collection<UnsuccessfulItem.Builder> getUnsuccessful() {
            return unsuccessful != null ? unsuccessful.stream().map(UnsuccessfulItem::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder unsuccessful(Collection<UnsuccessfulItem> unsuccessful) {
            this.unsuccessful = UnsuccessfulItemListCopier.copy(unsuccessful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(UnsuccessfulItem... unsuccessful) {
            unsuccessful(Arrays.asList(unsuccessful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(Consumer<UnsuccessfulItem.Builder>... unsuccessful) {
            unsuccessful(Stream.of(unsuccessful).map(c -> UnsuccessfulItem.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUnsuccessful(Collection<UnsuccessfulItem.BuilderImpl> unsuccessful) {
            this.unsuccessful = UnsuccessfulItemListCopier.copyFromBuilder(unsuccessful);
        }

        @Override
        public ModifyHostsResponse build() {
            return new ModifyHostsResponse(this);
        }
    }
}
