/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a load permission.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LoadPermission implements ToCopyableBuilder<LoadPermission.Builder, LoadPermission> {
    private final String userId;

    private final String group;

    private LoadPermission(BuilderImpl builder) {
        this.userId = builder.userId;
        this.group = builder.group;
    }

    /**
     * <p>
     * The AWS account ID.
     * </p>
     * 
     * @return The AWS account ID.
     */
    public String userId() {
        return userId;
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #group} will return
     * {@link PermissionGroup#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupAsString}.
     * </p>
     * 
     * @return The name of the group.
     * @see PermissionGroup
     */
    public PermissionGroup group() {
        return PermissionGroup.fromValue(group);
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #group} will return
     * {@link PermissionGroup#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupAsString}.
     * </p>
     * 
     * @return The name of the group.
     * @see PermissionGroup
     */
    public String groupAsString() {
        return group;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(groupAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadPermission)) {
            return false;
        }
        LoadPermission other = (LoadPermission) obj;
        return Objects.equals(userId(), other.userId()) && Objects.equals(groupAsString(), other.groupAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("LoadPermission").add("UserId", userId()).add("Group", groupAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserId":
            return Optional.of(clazz.cast(userId()));
        case "Group":
            return Optional.of(clazz.cast(groupAsString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, LoadPermission> {
        /**
         * <p>
         * The AWS account ID.
         * </p>
         * 
         * @param userId
         *        The AWS account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param group
         *        The name of the group.
         * @see PermissionGroup
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionGroup
         */
        Builder group(String group);

        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param group
         *        The name of the group.
         * @see PermissionGroup
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionGroup
         */
        Builder group(PermissionGroup group);
    }

    static final class BuilderImpl implements Builder {
        private String userId;

        private String group;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadPermission model) {
            userId(model.userId);
            group(model.group);
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getGroup() {
            return group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        @Override
        public final Builder group(PermissionGroup group) {
            this.group(group.toString());
            return this;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public LoadPermission build() {
            return new LoadPermission(this);
        }
    }
}
