/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * [EC2-VPC only] Describes an IPv6 range.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Ipv6Range implements ToCopyableBuilder<Ipv6Range.Builder, Ipv6Range> {
    private final String cidrIpv6;

    private final String description;

    private Ipv6Range(BuilderImpl builder) {
        this.cidrIpv6 = builder.cidrIpv6;
        this.description = builder.description;
    }

    /**
     * <p>
     * The IPv6 CIDR range. You can either specify a CIDR range or a source security group, not both. To specify a
     * single IPv6 address, use the /128 prefix length.
     * </p>
     * 
     * @return The IPv6 CIDR range. You can either specify a CIDR range or a source security group, not both. To specify
     *         a single IPv6 address, use the /128 prefix length.
     */
    public String cidrIpv6() {
        return cidrIpv6;
    }

    /**
     * <p>
     * A description for the security group rule that references this IPv6 address range.
     * </p>
     * <p>
     * Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and
     * ._-:/()#,@[]+=;{}!$*
     * </p>
     * 
     * @return A description for the security group rule that references this IPv6 address range.</p>
     *         <p>
     *         Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and
     *         ._-:/()#,@[]+=;{}!$*
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cidrIpv6());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ipv6Range)) {
            return false;
        }
        Ipv6Range other = (Ipv6Range) obj;
        return Objects.equals(cidrIpv6(), other.cidrIpv6()) && Objects.equals(description(), other.description());
    }

    @Override
    public String toString() {
        return ToString.builder("Ipv6Range").add("CidrIpv6", cidrIpv6()).add("Description", description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CidrIpv6":
            return Optional.of(clazz.cast(cidrIpv6()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Ipv6Range> {
        /**
         * <p>
         * The IPv6 CIDR range. You can either specify a CIDR range or a source security group, not both. To specify a
         * single IPv6 address, use the /128 prefix length.
         * </p>
         * 
         * @param cidrIpv6
         *        The IPv6 CIDR range. You can either specify a CIDR range or a source security group, not both. To
         *        specify a single IPv6 address, use the /128 prefix length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrIpv6(String cidrIpv6);

        /**
         * <p>
         * A description for the security group rule that references this IPv6 address range.
         * </p>
         * <p>
         * Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and
         * ._-:/()#,@[]+=;{}!$*
         * </p>
         * 
         * @param description
         *        A description for the security group rule that references this IPv6 address range.</p>
         *        <p>
         *        Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and
         *        ._-:/()#,@[]+=;{}!$*
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String cidrIpv6;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(Ipv6Range model) {
            cidrIpv6(model.cidrIpv6);
            description(model.description);
        }

        public final String getCidrIpv6() {
            return cidrIpv6;
        }

        @Override
        public final Builder cidrIpv6(String cidrIpv6) {
            this.cidrIpv6 = cidrIpv6;
            return this;
        }

        public final void setCidrIpv6(String cidrIpv6) {
            this.cidrIpv6 = cidrIpv6;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Ipv6Range build() {
            return new Ipv6Range(this);
        }
    }
}
