/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the instance status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceStatusDetails implements ToCopyableBuilder<InstanceStatusDetails.Builder, InstanceStatusDetails> {
    private final Instant impairedSince;

    private final String name;

    private final String status;

    private InstanceStatusDetails(BuilderImpl builder) {
        this.impairedSince = builder.impairedSince;
        this.name = builder.name;
        this.status = builder.status;
    }

    /**
     * <p>
     * The time when a status check failed. For an instance that was launched and impaired, this is the time when the
     * instance was launched.
     * </p>
     * 
     * @return The time when a status check failed. For an instance that was launched and impaired, this is the time
     *         when the instance was launched.
     */
    public Instant impairedSince() {
        return impairedSince;
    }

    /**
     * <p>
     * The type of instance status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link StatusName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The type of instance status.
     * @see StatusName
     */
    public StatusName name() {
        return StatusName.fromValue(name);
    }

    /**
     * <p>
     * The type of instance status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link StatusName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The type of instance status.
     * @see StatusName
     */
    public String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status.
     * @see StatusType
     */
    public StatusType status() {
        return StatusType.fromValue(status);
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status.
     * @see StatusType
     */
    public String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(impairedSince());
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStatusDetails)) {
            return false;
        }
        InstanceStatusDetails other = (InstanceStatusDetails) obj;
        return Objects.equals(impairedSince(), other.impairedSince()) && Objects.equals(nameAsString(), other.nameAsString())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("InstanceStatusDetails").add("ImpairedSince", impairedSince()).add("Name", nameAsString())
                .add("Status", statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImpairedSince":
            return Optional.of(clazz.cast(impairedSince()));
        case "Name":
            return Optional.of(clazz.cast(nameAsString()));
        case "Status":
            return Optional.of(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceStatusDetails> {
        /**
         * <p>
         * The time when a status check failed. For an instance that was launched and impaired, this is the time when
         * the instance was launched.
         * </p>
         * 
         * @param impairedSince
         *        The time when a status check failed. For an instance that was launched and impaired, this is the time
         *        when the instance was launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impairedSince(Instant impairedSince);

        /**
         * <p>
         * The type of instance status.
         * </p>
         * 
         * @param name
         *        The type of instance status.
         * @see StatusName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusName
         */
        Builder name(String name);

        /**
         * <p>
         * The type of instance status.
         * </p>
         * 
         * @param name
         *        The type of instance status.
         * @see StatusName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusName
         */
        Builder name(StatusName name);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see StatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see StatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusType
         */
        Builder status(StatusType status);
    }

    static final class BuilderImpl implements Builder {
        private Instant impairedSince;

        private String name;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStatusDetails model) {
            impairedSince(model.impairedSince);
            name(model.name);
            status(model.status);
        }

        public final Instant getImpairedSince() {
            return impairedSince;
        }

        @Override
        public final Builder impairedSince(Instant impairedSince) {
            this.impairedSince = impairedSince;
            return this;
        }

        public final void setImpairedSince(Instant impairedSince) {
            this.impairedSince = impairedSince;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(StatusName name) {
            this.name(name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public InstanceStatusDetails build() {
            return new InstanceStatusDetails(this);
        }
    }
}
